<?php

if (!defined('ABSPATH'))
    exit;

class wos_admin {

    /**
     * The single instance
     * @var    object
     * @access  private
     * @since    1.0.0
     */
    private static $_instance = null;

    /**
     * The main plugin object.
     * @var    object
     * @access  public
     * @since    1.0.0
     */
    public $parent = null;

    /**
     * Prefix for plugin settings.
     * @var     string
     * @access  public
     * Delete
     * @since   1.0.0
     */
    public $base = '';

    /**
     * Available settings for plugin.
     * @var     array
     * @access  public
     * @since   1.0.0
     */
    public $settings = array();

    public function __construct($parent) {
        $this->parent = $parent;
        $this->base = 'wos_';
        $this->dir = dirname($this->parent->file);
        add_action('admin_menu', array($this, 'add_menu_item'));
        add_action('admin_print_scripts', array($this, 'admin_scripts'));
        add_action('admin_print_styles', array($this, 'admin_styles'));
        add_action('wp_ajax_nopriv_wos_saveSettings', array($this, 'saveSettings'));
        add_action('wp_ajax_wos_saveSettings', array($this, 'saveSettings'));
        add_action('wp_ajax_nopriv_wos_saveDesign', array($this, 'saveDesign'));
        add_action('wp_ajax_wos_saveDesign', array($this, 'saveDesign'));

        add_action('wp_ajax_nopriv_wos_loadSettings', array($this, 'loadSettings'));
        add_action('wp_ajax_wos_loadSettings', array($this, 'loadSettings'));
        add_action('wp_ajax_nopriv_wos_saveShortcut', array($this, 'saveShortcut'));
        add_action('wp_ajax_wos_saveShortcut', array($this, 'saveShortcut'));
        add_action('wp_ajax_nopriv_wos_deleteShortcut', array($this, 'deleteShortcut'));
        add_action('wp_ajax_wos_deleteShortcut', array($this, 'deleteShortcut'));
        add_action('wp_ajax_nopriv_wos_deleteAllShortcuts', array($this, 'deleteAllShortcuts'));
        add_action('wp_ajax_wos_deleteAllShortcuts', array($this, 'deleteAllShortcuts'));

        add_action('wp_ajax_nopriv_wos_applyShortcutsRole', array($this, 'applyShortcutsRole'));
        add_action('wp_ajax_wos_applyShortcutsRole', array($this, 'applyShortcutsRole'));
        add_action('wp_ajax_nopriv_wos_checkURL', array($this, 'checkURL'));
        add_action('wp_ajax_wos_checkURL', array($this, 'checkURL'));

        add_action('init', array($this, 'detectPluginActivation'));
        add_action('init', array($this, 'initAdmin'));
        add_action('admin_init', array($this, 'checkAutomaticUpdates'));
        add_action('wp_logout', array($this, 'endSession'));
        add_action('wp_login', array($this, 'endSession'));
    }

    public function wos_SkinBodyClass($classes) {
        return $classes . ' wos_skin';
    }

    public function wos_ViewBodyClass($classes) {
        return $classes . ' wos_view';
    }

    public function initAdmin() {
        $settings = $this->getSettings();
        $this->generateCustomCSS();
        if ($settings->enableWOS && $this->checkRolesRight() && !is_network_admin()) {
            if (!isset($_GET['wos_reload'])) {
                add_filter('admin_body_class', array($this, 'wos_ViewBodyClass'));
            }
        }

        if ($settings->useAdminSkin) {
            add_filter('admin_body_class', array($this, 'wos_SkinBodyClass'));
        }
    }

    /**
     * Add menu to admin
     * @return void
     */
    public function add_menu_item() {
        $settings = $this->getSettings();
        if (current_user_can('manage_options')) {
            add_menu_page('WP OS Desktop', esc_html__("WP OS Desktop", 'wos'), 'manage_options', 'wos_menu', array($this, 'view_settings_wos'), 'dashicons-welcome-view-site');
            if (current_user_can('manage_options') && $settings->useAdminSkin) {
                add_submenu_page('wos_menu', esc_html__('Desktop appearance', 'wos'), esc_html__('Appearance', 'wos'), 'manage_options', 'wos_design', array($this, 'view_design_wos'));
            }
        } elseif ($settings->enableWOS && $this->checkRolesRight() && $settings->usersCanChangeStyles && !is_network_admin()) {
            add_menu_page('WP OS Desktop', esc_html__("Desktop appearance", 'wos'), 'read', 'wos_design', array($this, 'view_design_wos'), 'dashicons-welcome-view-site');
        }

        if ($settings->enableWOS && $this->checkRolesRight() && !is_network_admin()) {
            add_menu_page('WP OS Desktop Browser', esc_html__("Web Browser", 'wos'), 'read', 'wos_browser', array($this, 'web_browser'), 'dashicons-admin-site');
        }
        $menuSlag = 'wos_menu';
    }

    public function getSettings() {
        global $wpdb;
        $table_name = $wpdb->prefix . "wos_settings";
        $settings = $wpdb->get_results("SELECT * FROM $table_name WHERE id=1 LIMIT 1");
        $settings = $settings[0];
        return $settings;
    }

    public function loadSettings() {
        $modeDesign = sanitize_text_field($_POST['modeDesign']);
        $settings = $this->getSettings();
        if ($modeDesign == 1) {
            unset($settings->purchaseCode);
            if (get_user_option('wos_colorWinHeader') != false) {
                $settings->colorWinHeader = get_user_option('wos_colorWinHeader');
            }
            if (get_user_option('wos_colorWinHeaderBg') != false) {
                $settings->colorWinHeaderBg = get_user_option('wos_colorWinHeaderBg');
            }
            if (get_user_option('wos_colorWinIconsBg') != false) {
                $settings->colorWinIconsBg = get_user_option('wos_colorWinIconsBg');
            }
            if (get_user_option('wos_colorWinIcons') != false) {
                $settings->colorWinIcons = get_user_option('wos_colorWinIcons');
            }
            if (get_user_option('wos_colorWinIconsSelected') != false) {
                $settings->colorWinIconsSelected = get_user_option('wos_colorWinIconsSelected');
            }
            if (get_user_option('wos_colorWPMenuLinks') != false) {
                $settings->colorWPMenuLinks = get_user_option('wos_colorWPMenuLinks');
            }

            if (get_user_option('wos_colorWPMenuBadges') != false) {
                $settings->colorWPMenuBadges = get_user_option('wos_colorWPMenuBadges');
            }
            if (get_user_option('wos_colorShortcuts') != false) {
                $settings->colorShortcuts = get_user_option('wos_colorShortcuts');
            }
            if (get_user_option('wos_colorContextmenuBg') != false) {
                $settings->colorContextmenuBg = get_user_option('wos_colorContextmenuBg');
            }
            if (get_user_option('wos_colorContextmenuLinks') != false) {
                $settings->colorContextmenuLinks = get_user_option('wos_colorContextmenuLinks');
            }
            if (get_user_option('wos_colorContextmenuLinksHover') != false) {
                $settings->colorContextmenuLinksHover = get_user_option('wos_colorContextmenuLinksHover');
            }
            if (get_user_option('wos_fxWinGray') != false) {
                $settings->fxWinGray = get_user_option('wos_fxWinGray');
                if (get_user_option('wos_fxWinGray') == 'false') {
                    $settings->fxWinGray = 0;
                }
            }
            if (get_user_option('wos_fxWinBlur') != false) {
                $settings->fxWinBlur = get_user_option('wos_fxWinBlur');
                if (get_user_option('wos_fxWinBlur') == 'false') {
                    $settings->fxWinBlur = 0;
                }
            }
            if (get_user_option('wos_fxWinDark') != false) {
                $settings->fxWinDark = get_user_option('wos_fxWinDark');
                if (get_user_option('wos_fxWinDark') == 'false') {
                    $settings->fxWinDark = 0;
                }
            }
            if (get_user_option('wos_useVideoBackground') != false) {
                $settings->useVideoBackground = get_user_option('wos_useVideoBackground');
            }
            if (get_user_option('wos_backgroundImage') != false) {
                $settings->backgroundImage = get_user_option('wos_backgroundImage');
            }
            if (get_user_option('wos_backgroundVideo') != false) {
                $settings->backgroundVideo = get_user_option('wos_backgroundVideo');
            }
            if (get_user_option('wos_colorBottomBar') != false) {
                $settings->colorBottomBar = get_user_option('wos_colorBottomBar');
            }
            if (get_user_option('wos_colorBottomAlpha') != false) {
                $settings->colorBottomAlpha = get_user_option('wos_colorBottomAlpha');
                if (get_user_option('wos_colorBottomAlpha') == 'false') {
                    $settings->colorBottomAlpha = 0;
                }
            }
            if (get_user_option('wos_colorBg') != false) {
                $settings->colorBg = get_user_option('wos_colorBg');
            }

            if (get_user_option('wos_skin_topBarColorBg') != false) {
                $settings->skin_topBarColorBg = get_user_option('wos_skin_topBarColorBg');
            }
            if (get_user_option('wos_skin_topBarLinksColorBg') != false) {
                $settings->skin_topBarLinksColorBg = get_user_option('wos_skin_topBarLinksColorBg');
            }
            if (get_user_option('wos_skin_topBarLinksColorBgHover') != false) {
                $settings->skin_topBarLinksColorBgHover = get_user_option('wos_skin_topBarLinksColorBgHover');
            }
            if (get_user_option('wos_skin_topBarLinksColor') != false) {
                $settings->skin_topBarLinksColor = get_user_option('wos_skin_topBarLinksColor');
            }
            if (get_user_option('wos_skin_topBarLinksColorSubmenu') != false) {
                $settings->skin_topBarLinksColorSubmenu = get_user_option('wos_skin_topBarLinksColorSubmenu');
            }

            if (get_user_option('wos_skin_topBarLinksColorSubmenuHover') != false) {
                $settings->skin_topBarLinksColorSubmenuHover = get_user_option('wos_skin_topBarLinksColorSubmenuHover');
            }
            if (get_user_option('wos_skin_sideBarColorBg') != false) {
                $settings->skin_sideBarColorBg = get_user_option('wos_skin_sideBarColorBg');
            }
            if (get_user_option('wos_skin_sideBarLinksColorBg') != false) {
                $settings->skin_sideBarLinksColorBg = get_user_option('wos_skin_sideBarLinksColorBg');
            }
            if (get_user_option('wos_skin_sideBarLinksColorBgHover') != false) {
                $settings->skin_sideBarLinksColorBgHover = get_user_option('wos_skin_sideBarLinksColorBgHover');
            }
            if (get_user_option('wos_skin_sideBarLinksColorSubmenu') != false) {
                $settings->skin_sideBarLinksColorSubmenu = get_user_option('wos_skin_sideBarLinksColorSubmenu');
            }
            if (get_user_option('wos_skin_sideBarLinksColorSubmenuActive') != false) {
                $settings->skin_sideBarLinksColorSubmenuActive = get_user_option('wos_skin_sideBarLinksColorSubmenuActive');
            }
            if (get_user_option('wos_skin_sideBarHeaderColorSubmenuActiveBg') != false) {
                $settings->skin_sideBarHeaderColorSubmenuActiveBg = get_user_option('wos_skin_sideBarHeaderColorSubmenuActiveBg');
            }
            if (get_user_option('wos_skin_sideBarHeaderColorSubmenuActive') != false) {
                $settings->skin_sideBarHeaderColorSubmenuActive = get_user_option('wos_skin_sideBarHeaderColorSubmenuActive');
            }


            if (get_user_option('wos_skin_sideBarLinksColorSubmenuHover') != false) {
                $settings->skin_sideBarLinksColorSubmenuHover = get_user_option('wos_skin_sideBarLinksColorSubmenuHover');
            }
            if (get_user_option('wos_skin_sideBarLinksColor') != false) {
                $settings->skin_sideBarLinksColor = get_user_option('wos_skin_sideBarLinksColor');
            }
            if (get_user_option('wos_skin_sideBarLinksColorHover') != false) {
                $settings->skin_sideBarLinksColorHover = get_user_option('wos_skin_sideBarLinksColorHover');
            }


            if (get_user_option('wos_skin_googleFont') != false) {
                $settings->skin_googleFont = get_user_option('wos_skin_googleFont');
            }
            if (get_user_option('wos_skin_colorBtnPrimary') != false) {
                $settings->skin_colorBtnPrimary = get_user_option('wos_skin_colorBtnPrimary');
            }
            if (get_user_option('wos_skin_colorBtnPrimaryBg') != false) {
                $settings->skin_colorBtnPrimaryBg = get_user_option('wos_skin_colorBtnPrimaryBg');
            }
            if (get_user_option('wos_skin_colorBtnSecondary') != false) {
                $settings->skin_colorBtnSecondary = get_user_option('wos_skin_colorBtnSecondary');
            }
            if (get_user_option('wos_skin_colorBtnSecondaryBg') != false) {
                $settings->skin_colorBtnSecondaryBg = get_user_option('wos_skin_colorBtnSecondaryBg');
            }
            if (get_user_option('wos_skin_colorBtnDefault') != false) {
                $settings->skin_colorBtnDefault = get_user_option('wos_skin_colorBtnDefault');
            }
            if (get_user_option('wos_skin_colorBtnDefaultBg') != false) {
                $settings->skin_colorBtnDefaultBg = get_user_option('wos_skin_colorBtnDefaultBg');
            }
            if (get_user_option('wos_skin_pageBg') != false) {
                $settings->skin_pageBg = get_user_option('wos_skin_pageBg');
            }
            if (get_user_option('wos_skin_linksColor') != false) {
                $settings->skin_linksColor = get_user_option('wos_skin_linksColor');
            }
            if (get_user_option('wos_skin_headersColor') != false) {
                $settings->skin_headersColor = get_user_option('wos_skin_headersColor');
            }
            if (get_user_option('wos_skin_headersColorBg') != false) {
                $settings->skin_headersColorBg = get_user_option('wos_skin_headersColorBg');
            }
        } else if (!current_user_can('manage_options')) {
            $settings = new stdClass();
        }

        echo(json_encode($settings));

        die();
    }

    public function detectPluginActivation() {
        if (!session_id()) {
            session_start();
        }
        if (isset($_GET['action']) && ($_GET['action'] == 'activate' || $_GET['action'] == 'deactivate')) {
            $_SESSION['wos_loadPageBackend'] = 1;
        }
    }

    /*
     * Check for updates
     */

    function checkAutomaticUpdates() {
        $settings = $this->getSettings();
        if ($settings && $settings->purchaseCode != "") {
            require_once('wos_plugin_update_check.php');
            $updateCheckerWos = new PluginUpdateChecker_2_0(
                    'https://kernl.us/api/v1/updates/5718cb711e14737d770078b8/', $this->parent->file, 'wos', 1
            );
            $updateCheckerWos->purchaseCode = $settings->purchaseCode;
        }
    }

    public function endSession() {
        session_destroy();
    }

    private function hex2rgba($color, $opacity = false) {

        $default = 'rgb(0,0,0)';

        //Return default if no color provided
        if (empty($color))
            return $default;

        //Sanitize $color if "#" is provided 
        if ($color[0] == '#') {
            $color = substr($color, 1);
        }

        //Check if color has 6 or 3 characters and get values
        if (strlen($color) == 6) {
            $hex = array($color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5]);
        } elseif (strlen($color) == 3) {
            $hex = array($color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2]);
        } else {
            return $default;
        }

        //Convert hexadec to rgb
        $rgb = array_map('hexdec', $hex);

        //Check if opacity is set(rgba or rgb)
        if ($opacity) {
            if (abs($opacity) > 1)
                $opacity = 1.0;
            $output = 'rgba(' . implode(",", $rgb) . ',' . $opacity . ')';
        } else {
            $output = 'rgb(' . implode(",", $rgb) . ')';
        }

        //Return rgb(a) color string
        return $output;
    }

    public function options_custom_styles() {
        $settings = $this->getSettings();
        if (current_user_can('manage_options') || $settings->usersCanChangeStyles) {
            if (get_user_option('wos_colorWinHeader') != false) {
                $settings->colorWinHeader = get_user_option('wos_wos_colorWinHeader');
            }
            if (get_user_option('wos_wos_colorWinHeaderBg') != false) {
                $settings->colorWinHeaderBg = get_user_option('wos_colorWinHeaderBg');
            }
            if (get_user_option('wos_colorWinIconsBg') != false) {
                $settings->colorWinIconsBg = get_user_option('wos_colorWinIconsBg');
            }
            if (get_user_option('wos_colorWinIcons') != false) {
                $settings->colorWinIcons = get_user_option('wos_colorWinIcons');
            }
            if (get_user_option('wos_colorWinIconsSelected') != false) {
                $settings->colorWinIconsSelected = get_user_option('wos_colorWinIconsSelected');
            }
            if (get_user_option('wos_colorWPMenuLinks') != false) {
                $settings->colorWPMenuLinks = get_user_option('wos_colorWPMenuLinks');
            }
            if (get_user_option('wos_colorWPMenuBadges') != false) {
                $settings->colorWPMenuBadges = get_user_option('wos_colorWPMenuBadges');
            }
            if (get_user_option('wos_colorShortcuts') != false) {
                $settings->colorShortcuts = get_user_option('wos_colorShortcuts');
            }
            if (get_user_option('wos_colorContextmenuBg') != false) {
                $settings->colorContextmenuBg = get_user_option('wos_colorContextmenuBg');
            }
            if (get_user_option('wos_colorContextmenuLinks') != false) {
                $settings->colorContextmenuLinks = get_user_option('wos_colorContextmenuLinks');
            }
            if (get_user_option('wos_colorContextmenuLinksHover') != false) {
                $settings->colorContextmenuLinksHover = get_user_option('wos_colorContextmenuLinksHover');
            }
            if (get_user_option('wos_fxWinGray') != false) {
                $settings->fxWinGray = get_user_option('wos_fxWinGray');
            }
            if (get_user_option('wos_fxWinBlur') != false) {
                $settings->fxWinBlur = get_user_option('wos_fxWinBlur');
            }
            if (get_user_option('wos_fxWinDark') != false) {
                $settings->fxWinDark = get_user_option('wos_fxWinDark');
            }
            if (get_user_option('wos_backgroundImage') != false) {
                $settings->backgroundImage = get_user_option('wos_backgroundImage');
            }
            if (get_user_option('wos_useVideoBackground') != false) {
                $settings->useVideoBackground = get_user_option('wos_useVideoBackground');
            }
            if (get_user_option('wos_backgroundVideo') != false) {
                $settings->backgroundVideo = get_user_option('wos_backgroundVideo');
            }
            if (get_user_option('wos_colorBottomBar') != false) {
                $settings->colorBottomBar = get_user_option('wos_colorBottomBar');
            }
            if (get_user_option('wos_colorBottomAlpha') != false) {
                $settings->colorBottomAlpha = get_user_option('wos_colorBottomAlpha');
            }
            if (get_user_option('wos_colorBg') != false) {
                $settings->colorBg = get_user_option('wos_colorBg');
            }

            if ($settings->useAdminSkin) {
                if (get_user_option('wos_skin_topBarColorBg') != false) {
                    $settings->skin_topBarColorBg = get_user_option('wos_skin_topBarColorBg');
                }
                if (get_user_option('wos_skin_topBarLinksColorBg') != false) {
                    $settings->skin_topBarLinksColorBg = get_user_option('wos_skin_topBarLinksColorBg');
                }
                if (get_user_option('wos_skin_topBarLinksColorBgHover') != false) {
                    $settings->skin_topBarLinksColorBgHover = get_user_option('wos_skin_topBarLinksColorBgHover');
                }
                if (get_user_option('wos_skin_topBarLinksColor') != false) {
                    $settings->skin_topBarLinksColor = get_user_option('wos_skin_topBarLinksColor');
                }
                if (get_user_option('wos_skin_topBarLinksColorSubmenu') != false) {
                    $settings->skin_topBarLinksColorSubmenu = get_user_option('wos_skin_topBarLinksColorSubmenu');
                }
                if (get_user_option('wos_skin_topBarLinksColorSubmenuHover') != false) {
                    $settings->skin_topBarLinksColorSubmenuHover = get_user_option('wos_skin_topBarLinksColorSubmenuHover');
                }
                if (get_user_option('wos_skin_sideBarColorBg') != false) {
                    $settings->skin_sideBarColorBg = get_user_option('wos_skin_sideBarColorBg');
                }
                if (get_user_option('wos_skin_sideBarLinksColorBg') != false) {
                    $settings->skin_sideBarLinksColorBg = get_user_option('wos_skin_sideBarLinksColorBg');
                }
                if (get_user_option('wos_skin_sideBarLinksColorBgHover') != false) {
                    $settings->skin_sideBarLinksColorBgHover = get_user_option('wos_skin_sideBarLinksColorBgHover');
                }
                if (get_user_option('wos_skin_topBarLinksColorSubmenu') != false) {
                    $settings->skin_topBarLinksColorSubmenu = get_user_option('wos_skin_topBarLinksColorSubmenu');
                }
                if (get_user_option('wos_skin_sideBarLinksColorSubmenuHover') != false) {
                    $settings->skin_sideBarLinksColorSubmenuHover = get_user_option('wos_skin_sideBarLinksColorSubmenuHover');
                }
                if (get_user_option('wos_skin_sideBarLinksColor') != false) {
                    $settings->skin_sideBarLinksColor = get_user_option('wos_skin_sideBarLinksColor');
                }
                if (get_user_option('wos_skin_sideBarLinksColorHover') != false) {
                    $settings->skin_sideBarLinksColorHover = get_user_option('wos_skin_sideBarLinksColorHover');
                }



                if (get_user_option('wos_skin_googleFont') != false) {
                    $settings->skin_googleFont = get_user_option('wos_skin_googleFont');
                }
                if (get_user_option('wos_skin_colorBtnPrimary') != false) {
                    $settings->skin_colorBtnPrimary = get_user_option('wos_skin_colorBtnPrimary');
                }
                if (get_user_option('wos_skin_colorBtnPrimaryBg') != false) {
                    $settings->skin_colorBtnPrimaryBg = get_user_option('wos_skin_colorBtnPrimaryBg');
                }
                if (get_user_option('wos_skin_colorBtnSecondary') != false) {
                    $settings->skin_colorBtnSecondary = get_user_option('wos_skin_colorBtnSecondary');
                }
                if (get_user_option('wos_skin_colorBtnSecondaryBg') != false) {
                    $settings->skin_colorBtnSecondaryBg = get_user_option('wos_skin_colorBtnSecondaryBg');
                }
                if (get_user_option('wos_skin_colorBtnDefault') != false) {
                    $settings->skin_colorBtnDefault = get_user_option('wos_skin_colorBtnDefault');
                }
                if (get_user_option('wos_skin_colorBtnDefaultBg') != false) {
                    $settings->skin_colorBtnDefaultBg = get_user_option('wos_skin_colorBtnDefaultBg');
                }
                if (get_user_option('wos_skin_pageBg') != false) {
                    $settings->skin_pageBg = get_user_option('wos_skin_pageBg');
                }
                if (get_user_option('wos_skin_linksColor') != false) {
                    $settings->skin_linksColor = get_user_option('wos_skin_linksColor');
                }
                if (get_user_option('wos_skin_headersColor') != false) {
                    $settings->skin_headersColor = get_user_option('wos_skin_headersColor');
                }
                if (get_user_option('wos_skin_headersColorBg') != false) {
                    $settings->skin_headersColorBg = get_user_option('wos_skin_headersColorBg');
                }
            }
        }

        $settings->colorBottomBar = $this->hex2rgba($settings->colorBottomBar, $settings->colorBottomAlpha);
        /*

          $output .= "\n";
          if ($output != '') {
          $output = "\n<style id=\"wos_styles\" >\n" . $output . "</style>\n";
          echo $output;
          } */
    }

    /*
     * Load admin styles
     */

    function admin_styles() {
        $url = '';
        if (isset($_SERVER['HTTP_REFERER'])) {
            $url = $_SERVER['HTTP_REFERER'];
        }
        $settings = $this->getSettings();
        if ($settings->enableWOS && $this->checkRolesRight() && !is_network_admin()) {
            if (isset($_GET['wos_reload']) || $settings->firstStart) {
                wp_register_style($this->parent->_token . '_jqueryui', esc_url($this->parent->assets_url) . 'css/jquery-ui-theme/jquery-ui.min.css', array(), $this->parent->_version);
                wp_enqueue_style($this->parent->_token . '_jqueryui');
                wp_register_style($this->parent->_token . '_bootstrap', esc_url($this->parent->assets_url) . 'css/wos_bootstrap.min.css', array(), $this->parent->_version);
                wp_enqueue_style($this->parent->_token . '_bootstrap');
                wp_register_style($this->parent->_token . '_fontawesome', esc_url($this->parent->assets_url) . 'css/font-awesome.min.css', array(), $this->parent->_version);
                wp_enqueue_style($this->parent->_token . '_fontawesome');
                wp_register_style($this->parent->_token . '_flat-ui', esc_url($this->parent->assets_url) . 'css/wos_flat-ui-pro.min.css', array(), $this->parent->_version);
                wp_enqueue_style($this->parent->_token . '_flat-ui');
                wp_register_style($this->parent->_token . '_osBackend', esc_url($this->parent->assets_url) . 'css/wos_osBackend.min.css', array(), $this->parent->_version);
                wp_enqueue_style($this->parent->_token . '_osBackend');
            } else if (!isset($_GET['wos_reload'])) {
                wp_register_style($this->parent->_token . '_osBackendView', esc_url($this->parent->assets_url) . 'css/wos_osBackendView.min.css', array(), $this->parent->_version);
                wp_enqueue_style($this->parent->_token . '_osBackendView');
                if (isset($_GET['page']) && strpos($_GET['page'], 'wos_menu') !== false ||
                        isset($_GET['page']) && strpos($_GET['page'], 'wos_design') !== false) {
                    wp_register_style($this->parent->_token . '_jqueryui', esc_url($this->parent->assets_url) . 'css/jquery-ui-theme/jquery-ui.min.css', array(), $this->parent->_version);
                    wp_enqueue_style($this->parent->_token . '_jqueryui');
                    wp_register_style($this->parent->_token . '_colpick', esc_url($this->parent->assets_url) . 'css/wos_colpick.min.css', array(), $this->parent->_version);
                    wp_enqueue_style($this->parent->_token . '_colpick');
                    wp_register_style($this->parent->_token . '_bootstrap', esc_url($this->parent->assets_url) . 'css/wos_bootstrap.min.css', array(), $this->parent->_version);
                    wp_enqueue_style($this->parent->_token . '_bootstrap');
                    wp_register_style($this->parent->_token . '_flat-ui', esc_url($this->parent->assets_url) . 'css/wos_flat-ui-pro.min.css', array(), $this->parent->_version);
                    wp_enqueue_style($this->parent->_token . '_flat-ui');
                    wp_register_style($this->parent->_token . '_osBackendSettings', esc_url($this->parent->assets_url) . 'css/wos_osBackendSettings.min.css', array(), $this->parent->_version);
                    wp_enqueue_style($this->parent->_token . '_osBackendSettings');
                }
            }
        } else if (!is_network_admin()) {
            if (isset($_GET['page']) && (strpos($_GET['page'], 'wos_menu') !== false || strpos($_GET['page'], 'wos_design') !== false)) {
                wp_register_style($this->parent->_token . '_jqueryui', esc_url($this->parent->assets_url) . 'css/jquery-ui-theme/jquery-ui.min.css', array(), $this->parent->_version);
                wp_enqueue_style($this->parent->_token . '_jqueryui');
                wp_register_style($this->parent->_token . '_colpick', esc_url($this->parent->assets_url) . 'css/wos_colpick.min.css', array(), $this->parent->_version);
                wp_enqueue_style($this->parent->_token . '_colpick');
                wp_register_style($this->parent->_token . '_bootstrap', esc_url($this->parent->assets_url) . 'css/wos_bootstrap.min.css', array(), $this->parent->_version);
                wp_enqueue_style($this->parent->_token . '_bootstrap');
                wp_register_style($this->parent->_token . '_flat-ui', esc_url($this->parent->assets_url) . 'css/wos_flat-ui-pro.min.css', array(), $this->parent->_version);
                wp_enqueue_style($this->parent->_token . '_flat-ui');
                wp_register_style($this->parent->_token . '_osBackendSettings', esc_url($this->parent->assets_url) . 'css/wos_osBackendSettings.min.css', array(), $this->parent->_version);
                wp_enqueue_style($this->parent->_token . '_osBackendSettings');
            }
        }

        wp_register_style($this->parent->_token . '_customCss', esc_url($this->parent->assets_url) . 'css/wos_customCss.css', array(), $this->parent->_version);
        wp_enqueue_style($this->parent->_token . '_customCss');
        if ($settings->usersCanChangeStyles && file_exists($this->parent->assets_dir . '/css/wos_customCss_' . get_current_user_id() . '.css')) {

            wp_register_style($this->parent->_token . '_customCss_' . get_current_user_id(), esc_url($this->parent->assets_url) . 'css/wos_customCss_' . get_current_user_id() . '.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '_customCss_' . get_current_user_id());
        }
    }

    /*
     * Load admin scripts
     */

    function admin_scripts() {
        global $wpdb;
        $url = '';
        if (isset($_SERVER['HTTP_REFERER'])) {
            $url = $_SERVER['HTTP_REFERER'];
        }
        $settings = $this->getSettings();
        if ($settings->enableWOS && $this->checkRolesRight() && !is_network_admin()) {
            if (isset($_GET['wos_reload']) || $settings->firstStart) {
                wp_register_script('mousetrap', esc_url($this->parent->assets_url) . 'js/mousetrap.min.js', array('jquery'));
                wp_enqueue_script('mousetrap');
                wp_register_script($this->parent->_token . '_flat-ui', esc_url($this->parent->assets_url) . 'js/wos_flat-ui-pro.min.js', array('jquery'));
                wp_enqueue_script($this->parent->_token . '_flat-ui');
                wp_register_script($this->parent->_token . '_osBackend', esc_url($this->parent->assets_url) . 'js/wos_osBackend.min.js', array('jquery',
                    'jquery-ui-core',
                    'jquery-ui-mouse',
                    'jquery-ui-position',
                    'jquery-ui-droppable',
                    'jquery-ui-draggable',
                    'jquery-ui-resizable',
                    'jquery-effects-core',
                    'jquery-effects-drop',
                    'jquery-effects-fade',
                    'jquery-effects-bounce',
                    'jquery-ui-widget'), $this->parent->_version);
                wp_enqueue_script($this->parent->_token . '_osBackend');

                $userID = get_current_user_id();
                $canEditShortcuts = $settings->usersCanEditShortcut;
                if (current_user_can('manage_options')) {
                    $canEditShortcuts = true;
                }
                $canEditStyles = $settings->usersCanChangeStyles;
                $canEditSettings = false;
                if (current_user_can('manage_options')) {
                    $canEditStyles = true;
                    $canEditSettings = true;
                }

                $table_name = $wpdb->prefix . "wos_shortcuts";
                $links = $wpdb->get_results("SELECT * FROM $table_name WHERE userID=$userID");
                $js_data[] = array(
                    'adminUrl' => admin_url(),
                    'links' => $links,
                    'canEditShortcuts' => $canEditShortcuts,
                    'canEditStyles' => $canEditStyles,
                    'canEditSettings' => $canEditSettings,
                    'texts' => array(
                        'Save' => esc_html__('Save', 'wos'),
                        'Title' => esc_html__('Title', 'wos'),
                        'EditShortcut' => esc_html__('Edit a shortcut', 'wos'),
                        'Icon' => esc_html__('Icon', 'wos'),
                        'SelectIcon' => esc_html__('Select an icon', 'wos'),
                        'PageBookmarked' => esc_html__('Page bookmarked', 'wos'),
                        'Desktop appearance' => esc_html__('Desktop appearance', 'wos'),
                        'Delete all shortcuts' => esc_html__('Delete all shortcuts', 'wos'),
                        'Edit the settings' => esc_html__('Edit the settings', 'wos'),
                    ),
                    'key_nextWin_1' => $settings->key_nextWin_1,
                    'key_nextWin_2' => $settings->key_nextWin_2,
                    'key_prevWin_1' => $settings->key_prevWin_1,
                    'key_prevWin_2' => $settings->key_prevWin_2,
                    'key_prevWin_3' => $settings->key_prevWin_3,
                    'useVideoBackground' => $settings->useVideoBackground,
                    'backgroundVideo' => $settings->backgroundVideo,
                );
                wp_localize_script($this->parent->_token . '_osBackend', 'wos_data', $js_data);
                $table_name = $wpdb->prefix . "wos_settings";
                $wpdb->update($table_name, array('firstStart' => 0), array('id' => 1));
            } else if (!isset($_GET['wos_reload']) && !is_network_admin()) {
                wp_register_script('mousetrap', esc_url($this->parent->assets_url) . 'js/mousetrap.min.js', array('jquery'));
                wp_enqueue_script('mousetrap');
                wp_register_script($this->parent->_token . '_osBackendView', esc_url($this->parent->assets_url) . 'js/wos_osBackendView.min.js', array(), $this->parent->_version);
                wp_enqueue_script($this->parent->_token . '_osBackendView');

                $loadPageBackend = 0;
                if (isset($_SESSION['wos_loadPageBackend']) && $_SESSION['wos_loadPageBackend'] == 1) {
                    $_SESSION['wos_loadPageBackend'] = '';
                    $loadPageBackend = 1;
                }
                wp_localize_script($this->parent->_token . '_osBackendView', 'wos_data', array('loadPageBackend' => $loadPageBackend,
                    'key_nextWin_1' => $settings->key_nextWin_1,
                    'key_nextWin_2' => $settings->key_nextWin_2,
                    'key_prevWin_1' => $settings->key_prevWin_1,
                    'key_prevWin_2' => $settings->key_prevWin_2,
                    'key_prevWin_3' => $settings->key_prevWin_3));

                if (isset($_GET['page']) && strpos($_GET['page'], 'wos_menu') !== false ||
                        isset($_GET['page']) && strpos($_GET['page'], 'wos_design') !== false) {
                    wp_register_script($this->parent->_token . '_colpick', esc_url($this->parent->assets_url) . 'js/wos_colpick.min.js', array('jquery'), $this->parent->_version);
                    wp_enqueue_script($this->parent->_token . '_colpick');

                    wp_register_script($this->parent->_token . '_flat-ui', esc_url($this->parent->assets_url) . 'js/wos_flat-ui-pro.min.js', array('jquery'));
                    wp_enqueue_script($this->parent->_token . '_flat-ui');
                    wp_register_script($this->parent->_token . '_osBackendSettings', esc_url($this->parent->assets_url) . 'js/wos_osBackendSettings.min.js', array($this->parent->_token . '_flat-ui'), $this->parent->_version);

                    $js_data[] = array(
                        'assetsUrl' => esc_url($this->parent->assets_url),
                        'texts' => array(
                            'Yes' => esc_html__('Yes', 'wos'),
                            'No' => esc_html__('No', 'wos')
                        ),
                        'loadPageBackend' => $loadPageBackend
                    );

                    wp_localize_script($this->parent->_token . '_osBackendSettings', 'wos_data', $js_data);
                    wp_enqueue_script($this->parent->_token . '_osBackendSettings');
                }
            }
        } else if (!is_network_admin()) {
            if (isset($_GET['page']) && (strpos($_GET['page'], 'wos_menu') !== false || strpos($_GET['page'], 'wos_design') !== false)) {
                wp_register_script($this->parent->_token . '_colpick', esc_url($this->parent->assets_url) . 'js/wos_colpick.min.js', array('jquery'), $this->parent->_version);
                wp_enqueue_script($this->parent->_token . '_colpick');
                wp_register_script($this->parent->_token . '_flat-ui', esc_url($this->parent->assets_url) . 'js/wos_flat-ui-pro.min.js', array('jquery'));
                wp_enqueue_script($this->parent->_token . '_flat-ui');
                wp_register_script($this->parent->_token . '_osBackendSettings', esc_url($this->parent->assets_url) . 'js/wos_osBackendSettings.min.js', array(), $this->parent->_version);

                $js_data[] = array(
                    'assetsUrl' => esc_url($this->parent->assets_url),
                    'texts' => array(
                        'Yes' => esc_html__('Yes', 'wos'),
                        'No' => esc_html__('No', 'wos')
                    )
                );
                wp_localize_script($this->parent->_token . '_osBackendSettings', 'wos_data', $js_data);
                wp_enqueue_script($this->parent->_token . '_osBackendSettings');
            }
        }
    }

    private function checkRolesRight() {
        $settings = $this->getSettings();
        $chkOK = false;
        if ($settings->rolesAllowed == "") {
            $chkOK = true;
        } else {
            $rolesAllowed = explode(',', $settings->rolesAllowed);
            if (is_user_logged_in()) {
                $user = new WP_User(get_current_user_id());
                if (!empty($user->roles) && is_array($user->roles)) {
                    foreach ($user->roles as $role) {
                        if (in_array($role, $rolesAllowed)) {
                            $chkOK = true;
                        }
                    }
                }
            }
        }
        return $chkOK;
    }

    public function saveShortcut() {
        global $wpdb;

        if (is_user_logged_in()) {
            $url = sanitize_text_field($_POST['url']);
            $posX = sanitize_text_field($_POST['posX']);
            $posY = sanitize_text_field($_POST['posY']);
            $userID = get_current_user_id();
            $html = ($_POST['html']);
            echo $html;

            $table_name = $wpdb->prefix . "wos_shortcuts";
            $existingLinks = $wpdb->get_results("SELECT * FROM $table_name WHERE url='$url' AND userID=$userID LIMIT 1");
            if (count($existingLinks) > 0) {
                $existingLink = $existingLinks[0];
                if (isset($_POST['html']) && $_POST['html'] != "") {
                    $wpdb->update($table_name, array('posX' => $posX, 'posY' => $posY, 'html' => $html), array('id' => $existingLink->id));
                } else {
                    $wpdb->update($table_name, array('posX' => $posX, 'posY' => $posY), array('id' => $existingLink->id));
                }
            } else {
                $wpdb->insert($table_name, array('userID' => $userID, 'url' => $url, 'html' => $html, 'posX' => $posX, 'posY' => $posY));
            }
        }
        die();
    }

    public function deleteShortcut() {
        global $wpdb;
        if (is_user_logged_in()) {
            $url = sanitize_text_field($_POST['url']);
            $userID = get_current_user_id();

            $table_name = $wpdb->prefix . "wos_shortcuts";
            $wpdb->delete($table_name, array('url' => $url, 'userID' => $userID));
        }
        die();
    }

    public function deleteAllShortcuts() {
        global $wpdb;
        if (is_user_logged_in()) {
            $userID = get_current_user_id();
            $table_name = $wpdb->prefix . "wos_shortcuts";
            $wpdb->delete($table_name, array('userID' => $userID));
        }
        die();
    }

    public function saveDesign() {
        global $wpdb;
        $settings = $this->getSettings();
        $currentCode = $settings->purchaseCode;
        if (current_user_can('manage_options')) {
            $table_name = $wpdb->prefix . "wos_settings";
            $sqlDatas = array();
            foreach ($_POST as $key => $value) {
                if ($key != 'action' && $key != 'id' && $key != 'pll_ajax_backend' && $key != "undefined" && $key != "files") {
                    $sqlDatas[$key] = (stripslashes($value));
                }
            }
            $wpdb->update($table_name, $sqlDatas, array('id' => 1));
        }
        $user_id = get_current_user_id();
        update_user_option($user_id, 'wos_colorWinHeader', sanitize_text_field($_POST['colorWinHeader']));
        update_user_option($user_id, 'wos_colorWinHeaderBg', sanitize_text_field($_POST['colorWinHeaderBg']));
        update_user_option($user_id, 'wos_colorWinIconsBg', sanitize_text_field($_POST['colorWinIconsBg']));
        update_user_option($user_id, 'wos_colorWinIcons', sanitize_text_field($_POST['colorWinIcons']));
        update_user_option($user_id, 'wos_colorWinIconsSelected', sanitize_text_field($_POST['colorWinIconsSelected']));
        if (isset($_POST['colorWPMenuLinks'])) {
            update_user_option($user_id, 'wos_colorWPMenuLinks', sanitize_text_field($_POST['colorWPMenuLinks']));
        }
        if (isset($_POST['colorWPMenuLinks'])) {
            update_user_option($user_id, 'wos_colorWPMenuBadges', sanitize_text_field($_POST['colorWPMenuBadges']));
        }
        update_user_option($user_id, 'wos_colorShortcuts', sanitize_text_field($_POST['colorShortcuts']));
        update_user_option($user_id, 'wos_colorContextmenuBg', sanitize_text_field($_POST['colorContextmenuBg']));
        update_user_option($user_id, 'wos_colorContextmenuLinks', sanitize_text_field($_POST['colorContextmenuLinks']));
        update_user_option($user_id, 'wos_colorContextmenuLinksHover', sanitize_text_field($_POST['colorContextmenuLinksHover']));
        update_user_option($user_id, 'wos_colorBg', sanitize_text_field($_POST['colorBg']));
        update_user_option($user_id, 'wos_fxWinGray', sanitize_text_field($_POST['fxWinGray']));
        if ($_POST['fxWinGray'] == '0') {
            update_user_option($user_id, 'wos_fxWinGray', 'false');
        }
        update_user_option($user_id, 'wos_fxWinBlur', sanitize_text_field($_POST['fxWinBlur']));
        if (sanitize_text_field($_POST['fxWinBlur']) == '0') {
            update_user_option($user_id, 'wos_fxWinBlur', 'false');
        }
        update_user_option($user_id, 'wos_fxWinDark', sanitize_text_field($_POST['fxWinDark']));
        if (sanitize_text_field($_POST['fxWinDark']) == '0') {
            update_user_option($user_id, 'wos_fxWinDark', 'false');
        }
        update_user_option($user_id, 'wos_backgroundImage', sanitize_text_field($_POST['backgroundImage']));

        update_user_option($user_id, 'wos_useVideoBackground', sanitize_text_field($_POST['useVideoBackground']));
        if (sanitize_text_field($_POST['useVideoBackground']) == '0') {
            update_user_option($user_id, 'wos_useVideoBackground', 'false');
        }

        update_user_option($user_id, 'wos_backgroundVideo', sanitize_text_field($_POST['backgroundVideo']));
        if (sanitize_text_field($_POST['backgroundVideo']) == '0') {
            update_user_option($user_id, 'wos_backgroundVideo', 'false');
        }
        update_user_option($user_id, 'wos_colorBottomBar', sanitize_text_field($_POST['colorBottomBar']));
        if (sanitize_text_field($_POST['colorBottomBar']) == '0') {
            update_user_option($user_id, 'wos_colorBottomBar', 'false');
        }
        update_user_option($user_id, 'wos_colorBottomAlpha', sanitize_text_field($_POST['colorBottomAlpha']));
        if (sanitize_text_field($_POST['colorBottomAlpha']) == '0') {
            update_user_option($user_id, 'wos_colorBottomAlpha', 'false');
        }


        update_user_option($user_id, 'wos_skin_topBarColorBg', sanitize_text_field($_POST['skin_topBarColorBg']));
        update_user_option($user_id, 'wos_skin_topBarLinksColorBg', sanitize_text_field($_POST['skin_topBarLinksColorBg']));
        update_user_option($user_id, 'wos_skin_topBarLinksColorBgHover', sanitize_text_field($_POST['skin_topBarLinksColorBgHover']));
        update_user_option($user_id, 'wos_skin_topBarLinksColor', sanitize_text_field($_POST['skin_topBarLinksColor']));

        if (isset($_POST['skin_topBarLinksColorSubmenu'])) {
            update_user_option($user_id, 'wos_skin_topBarLinksColorSubmenu', sanitize_text_field($_POST['skin_topBarLinksColorSubmenu']));
        }
        update_user_option($user_id, 'wos_skin_topBarLinksColorSubmenuHover', sanitize_text_field($_POST['skin_topBarLinksColorSubmenuHover']));
        update_user_option($user_id, 'wos_skin_sideBarColorBg', sanitize_text_field($_POST['skin_sideBarColorBg']));
        update_user_option($user_id, 'wos_skin_sideBarLinksColorBg', sanitize_text_field($_POST['skin_sideBarLinksColorBg']));
        update_user_option($user_id, 'wos_skin_sideBarLinksColorBgHover', sanitize_text_field($_POST['skin_sideBarLinksColorBgHover']));
        update_user_option($user_id, 'wos_skin_sideBarLinksColorSubmenu', sanitize_text_field($_POST['skin_sideBarLinksColorSubmenu']));
        update_user_option($user_id, 'wos_skin_sideBarLinksColorSubmenuActive', sanitize_text_field($_POST['skin_sideBarLinksColorSubmenuActive']));
        update_user_option($user_id, 'wos_skin_sideBarHeaderColorSubmenuActiveBg', sanitize_text_field($_POST['skin_sideBarHeaderColorSubmenuActiveBg']));
        update_user_option($user_id, 'wos_skin_sideBarHeaderColorSubmenuActive', sanitize_text_field($_POST['skin_sideBarHeaderColorSubmenuActive']));
        update_user_option($user_id, 'wos_skin_sideBarLinksColorSubmenuHover', sanitize_text_field($_POST['skin_sideBarLinksColorSubmenuHover']));
        update_user_option($user_id, 'wos_skin_sideBarLinksColor', sanitize_text_field($_POST['skin_sideBarLinksColor']));
        update_user_option($user_id, 'wos_skin_sideBarLinksColorHover', sanitize_text_field($_POST['skin_sideBarLinksColorHover']));



        update_user_option($user_id, 'wos_skin_googleFont', sanitize_text_field($_POST['skin_googleFont']));
        update_user_option($user_id, 'wos_skin_colorBtnPrimary', sanitize_text_field($_POST['skin_colorBtnPrimary']));
        update_user_option($user_id, 'wos_skin_colorBtnPrimaryBg', sanitize_text_field($_POST['skin_colorBtnPrimaryBg']));
        update_user_option($user_id, 'wos_skin_colorBtnSecondary', sanitize_text_field($_POST['skin_colorBtnSecondary']));
        update_user_option($user_id, 'wos_skin_colorBtnSecondaryBg', sanitize_text_field($_POST['skin_colorBtnSecondaryBg']));
        update_user_option($user_id, 'wos_skin_colorBtnDefault', sanitize_text_field($_POST['skin_colorBtnDefault']));
        update_user_option($user_id, 'wos_skin_colorBtnDefaultBg', sanitize_text_field($_POST['skin_colorBtnDefaultBg']));
        update_user_option($user_id, 'wos_skin_pageBg', sanitize_text_field($_POST['skin_pageBg']));
        update_user_option($user_id, 'wos_skin_linksColor', sanitize_text_field($_POST['skin_linksColor']));
        update_user_option($user_id, 'wos_skin_headersColor', sanitize_text_field($_POST['skin_headersColor']));
        update_user_option($user_id, 'wos_skin_headersColorBg', sanitize_text_field($_POST['skin_headersColorBg']));

        $this->generateCustomCSS();

        die();
    }

    public function saveSettings() {
        global $wpdb;
        $settings = $this->getSettings();
        $currentCode = $settings->purchaseCode;
        if (current_user_can('manage_options')) {
            $table_name = $wpdb->prefix . "wos_settings";
            $sqlDatas = array();
            foreach ($_POST as $key => $value) {
                if ($key != 'action' && $key != 'id' && $key != 'pll_ajax_backend' && $key != "undefined" && $key != "files") {
                    $sqlDatas[$key] = (stripslashes($value));
                }
            }
            $wpdb->update($table_name, $sqlDatas, array('id' => 1));
        }
        if (isset($_POST['purchaseCode']) && $currentCode != $_POST['purchaseCode'] && $_POST['purchaseCode'] != "") {
            try {
                $url = 'http://www.loopus-plugins.com/updates/update.php?checkCode=15804874&code=' . sanitize_text_field($_POST['purchaseCode']);
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $rep = curl_exec($ch);
                if ($rep != '0410') {
                    $table_name = $wpdb->prefix . "wos_settings";
                    $wpdb->update($table_name, array('purchaseCode' => sanitize_text_field($_POST['purchaseCode'])), array('id' => 1));
                } else {

                    $table_name = $wpdb->prefix . "wos_settings";
                    $wpdb->update($table_name, array('purchaseCode' => ""), array('id' => 1));
                    echo '1';
                }
            } catch (Exception $e) {
                $table_name = $wpdb->prefix . "wos_settings";
                $wpdb->update($table_name, array('purchaseCode' => sanitize_text_field($_POST['purchaseCode'])), array('id' => 1));
            }
        }
        die();
    }

    public function web_browser() {
        echo '<div id="wos_bootstraped" class="wos_browserPanel">';
        echo '<table id="wos_browserTopPanel">';
        echo '<tr>';
        echo '<td><input type="text" id="wos_browserUrlField" class="form-control" placeholder="http://..." value="' . esc_url(home_url('/')) . '" /></td>';
        echo '<td class="wos_tdAction">'
        . '<a href="javascript:" id="wos_browserRefreshBtn" ><img src="' . $this->parent->assets_url . 'img/refresh-64.png" alt="' . esc_html__('Refresh', 'wos') . '" /></a>'
        . '<a href="javascript:" id="wos_browserBookmarkBtn"  ><img src="' . $this->parent->assets_url . 'img/bookmark-64.png" alt="' . esc_html__('Bookmark', 'wos') . '" /></a>'
        . '</td>';
        echo '</tr>';
        echo '</table>'; // eof #wos_browserTopPanel
        echo '<iframe id="wos_browserFrame" src="' . esc_url(home_url('/')) . '" ></iframe>';
        echo '<div id="wos_browserFooter" class="alert alert-info"><p>' . esc_html__('Please keep in mind that some websites may not be loaded through an iframe. This depends on the X-Frame-Options rule in the .htaccess file of the website', 'wos') . '.</p></div>';
        echo '</div>'; // eof #wos_bootstraped
    }

    public function view_design_wos() {
        wp_enqueue_style('thickbox');
        wp_enqueue_script('thickbox');
        $settings = $this->getSettings();
        echo '<div id="wos_bootstraped">';
        echo '<div id="wos_settings">';
        $margTop = '';
        if ((current_user_can('manage_options') || ($settings->enableWOS)) && $settings->useAdminSkin) {
            echo '<div class="wos_topBar">';
            echo '<a href="javascript:" data-tab="desktop" class="wos_active">' . esc_html__('Desktop', 'wos') . '</a>';
            echo '<a href="javascript:" data-tab="adminskin">' . esc_html__('Admin skin', 'wos') . '</a>';
            echo '</div>'; // eof .wos_topBar
        } else {
            $margTop = 'wos_margTop';
        }

        if (current_user_can('manage_options') || ($settings->enableWOS)) {
            echo '<div id="wos_designDesktopTab" class="' . $margTop . '">';
            echo '<div class="col-sm-4 col-xs-6">';
            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Background color of windows', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="colorWinHeaderBg" />';
            echo '</div>'; // eof .form-group
            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Text color of windows header', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="colorWinHeader" />';
            echo '</div>'; // eof .form-group
            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Background color of windows icons', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="colorWinIconsBg" />';
            echo '</div>'; // eof .form-group
            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Background color of activated windows icons', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="colorWinIconsSelected" />';
            echo '</div>'; // eof .form-group
            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Default color of windows icons', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="colorWinIcons" />';
            echo '</div>'; // eof .form-group
            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Color of shortcuts', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="colorShortcuts" />';
            echo '</div>'; // eof .form-group    

            echo '</div>';
            echo '<div class="col-sm-4 col-xs-6">';

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Background color of the context menu', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="colorContextmenuBg" />';
            echo '</div>'; // eof .form-group  
            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Color of the context menu links', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="colorContextmenuLinks" />';
            echo '</div>'; // eof .form-group  
            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Color of the context menu hovered links', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="colorContextmenuLinksHover" />';
            echo '</div>'; // eof .form-group    
            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Color of the bottom bar', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="colorBottomBar" />';
            echo '</div>'; // eof .form-group    
            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Opacity of the bottom bar', 'wos') . '</label>';
            echo '<div id="wos_colorBottomAlpha"></div>';
            echo '<input class="form-control"  name="colorBottomAlpha" type="number" step=".1" min="0" max="1" />';
            echo '</div>'; // eof .form-group   



            echo '</div>';
            echo '<div class="col-sm-4 col-xs-6">';

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="colorBg" />';
            echo '</div>'; // eof .form-group  

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Background image', 'wos') . '</label>';
            echo '<input class="form-control" name="backgroundImage"  />';
            if (current_user_can('upload_files')) {
                echo '<a class="btn btn-default wos_imageBtn wos_fieldBtn"><span class="glyphicon glyphicon-picture"></span></a>';
            }
            echo '</div>'; // eof .form-group

            echo '<div class="form-group">'
            . '<label>' . esc_html__('Use a Youtube video as background', 'wos') . '</label>'
            . '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>" name="useVideoBackground"/>'
            . '</div>'; // eof .form-group

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('URL of the Youtube video', 'wos') . '</label>';
            echo '<input class="form-control" placeholder="https://www.youtube.com/watch?v=P9zHeCA7EdE" name="backgroundVideo"  />';
            echo '</div>'; // eof .form-group

            echo '<div class="form-group">'
            . '<label>' . esc_html__('Gray effect on windows in background', 'wos') . '</label>'
            . '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>" name="fxWinGray"/>'
            . '</div>'; // eof .form-group
            echo '<div class="form-group">'
            . '<label>' . esc_html__('Blur effect on windows in background', 'wos') . '</label>'
            . '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>" name="fxWinBlur"/>'
            . '</div>'; // eof .form-group
            echo '<div class="form-group">'
            . '<label>' . esc_html__('Dark effect on windows in background', 'wos') . '</label>'
            . '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>"  name="fxWinDark"/>'
            . '</div>'; // eof .form-group
            echo '</div>';
            echo '</div>'; // eof #wos_designDesktopTab
        }
        if ($settings->useAdminSkin) {

            $colClass = "col-sm-4";
            if (current_user_can('manage_options')) {
                $colClass = "col-sm-3";
            }

            echo '<div id="wos_designSkinTab"  class="' . $margTop . '">';
            echo '<div class="' . $colClass . ' col-xs-6">';

            echo '<h6>' . esc_html__('Menus', 'wos') . '</h6>';
            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Google font', 'wos') . '</label>';
            echo '<input class="form-control" name="skin_googleFont" />';
            echo '<a href="https://support.google.com/analytics/answer/1032385?hl=en" target="_blank" wos_imageBtn class="btn btn-info btn-circle wos_fieldBtn"><span class="glyphicon glyphicon-info-sign"></span></a>';
            echo '</div>'; // eof .form-group    

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Top bar background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_topBarColorBg" />';
            echo '</div>'; // eof .form-group    

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Top bar links background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_topBarLinksColorBg" />';
            echo '</div>'; // eof .form-group  

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Top bar links color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_topBarLinksColor" />';
            echo '</div>'; // eof .form-group   

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Top bar submenus background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_topBarLinksColorBgHover" />';
            echo '</div>'; // eof .form-group  

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Top bar submenus links color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_topBarLinksColorHover" />';
            echo '</div>'; // eof .form-group   

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Top submenus hovered links color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_topBarLinksColorSubmenuHover" />';
            echo '</div>'; // eof .form-group   

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Sidebar background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_sideBarColorBg" />';
            echo '</div>'; // eof .form-group    


            echo '</div>'; // eof .col-sm-3   
            echo '<div class="' . $colClass . ' col-xs-6 wos_paddingTop" >';


            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Sidebar links background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_sideBarLinksColorBg" />';
            echo '</div>'; // eof .form-group  

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Sidebar links color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_sideBarLinksColor" />';
            echo '</div>'; // eof .form-group   

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Sidebar hovered links color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_sideBarLinksColorHover" />';
            echo '</div>'; // eof .form-group  

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Sidebar submenus background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_sideBarLinksColorBgHover" />';
            echo '</div>'; // eof .form-group  

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Sidebar submenus links color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_sideBarLinksColorSubmenu" />';
            echo '</div>'; // eof .form-group    


            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Sidebar submenus hovered links color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_sideBarLinksColorSubmenuHover" />';
            echo '</div>'; // eof .form-group  

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Sidebar submenus active header background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_sideBarHeaderColorSubmenuActiveBg" />';
            echo '</div>'; // eof .form-group   

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Sidebar submenus active header color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_sideBarHeaderColorSubmenuActive" />';
            echo '</div>'; // eof .form-group   

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Sidebar submenus active link color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_sideBarLinksColorSubmenuActive" />';
            echo '</div>'; // eof .form-group    

            echo '</div>'; // eof .col-sm-4   
            echo '<div class="' . $colClass . ' col-xs-6">';

            echo '<h6>' . esc_html__('Pages content', 'wos') . '</h6>';


            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Pages background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_pageBg" />';
            echo '</div>'; // eof .form-group  

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Default buttons texts color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_colorBtnDefault" />';
            echo '</div>'; // eof .form-group  


            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Default buttons background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_colorBtnDefaultBg" />';
            echo '</div>'; // eof .form-group  


            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Primary buttons texts color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_colorBtnPrimary" />';
            echo '</div>'; // eof .form-group  

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Primary buttons background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_colorBtnPrimaryBg" />';
            echo '</div>'; // eof .form-group  


            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Secondary buttons texts color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_colorBtnSecondary" />';
            echo '</div>'; // eof .form-group  

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Secondary buttons background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_colorBtnSecondaryBg" />';
            echo '</div>'; // eof .form-group  




            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Links color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_linksColor" />';
            echo '</div>'; // eof .form-group  

            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Headers texts color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_headersColor" />';
            echo '</div>'; // eof .form-group  
            echo '<div class="form-group">';
            echo '<label>' . esc_html__('Headers background color', 'wos') . '</label>';
            echo '<input class="form-control wos_colorpicker" name="skin_headersColorBg" />';
            echo '</div>'; // eof .form-group  


            echo '</div>'; // eof .col-sm-4   

            if (current_user_can('manage_options')) {
                echo '<div class="col-sm-3 col-xs-6">';
                echo '<h6>' . esc_html__('Login page', 'wos') . '</h6>';



                echo '<div class="form-group">';
                echo '<label>' . esc_html__('Background color', 'wos') . '</label>';
                echo '<input class="form-control wos_colorpicker" name="login_colorBg" />';
                echo '</div>'; // eof .form-group  

                echo '<div class="form-group">';
                echo '<label>' . esc_html__('Background image', 'wos') . '</label>';
                echo '<input class="form-control" name="login_backgroundImage" />';
                if (current_user_can('upload_files')) {
                    echo '<a class="btn btn-default wos_imageBtn wos_fieldBtn" ><span class="glyphicon glyphicon-picture"></span></a>';
                }
                echo '</div>'; // eof .form-group


                echo '<div class="form-group">'
                . '<label>' . esc_html__('Use a Youtube video as background', 'wos') . '</label>'
                . '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>" name="login_useVideoBackground"/>'
                . '</div>'; // eof .form-group


                echo '<div class="form-group">';
                echo '<label>' . esc_html__('URL of the Youtube video', 'wos') . '</label>';
                echo '<input class="form-control" placeholder="https://www.youtube.com/watch?v=P9zHeCA7EdE" name="login_backgroundVideo"  />';
                echo '</div>'; // eof .form-group

                echo '<div class="form-group">';
                echo '<label>' . esc_html__('Logo image', 'wos') . '</label>';
                echo '<input class="form-control" name="login_logo" />';
                if (current_user_can('upload_files')) {
                    echo '<a class="btn btn-default wos_imageBtn wos_fieldBtn" ><span class="glyphicon glyphicon-picture"></span></a>';
                }
                echo '</div>'; // eof .form-group

                echo '<div class="form-group">';
                echo '<label>' . esc_html__('Main color', 'wos') . '</label>';
                echo '<input class="form-control wos_colorpicker" name="login_mainColor" />';
                echo '</div>'; // eof .form-group  
                echo '<div class="form-group">';
                echo '<label>' . esc_html__('Panel texts color', 'wos') . '</label>';
                echo '<input class="form-control wos_colorpicker" name="login_panelColor" />';
                echo '</div>'; // eof .form-group  
                echo '<div class="form-group">';
                echo '<label>' . esc_html__('Panel background color', 'wos') . '</label>';
                echo '<input class="form-control wos_colorpicker" name="login_panelColorBg" />';
                echo '</div>'; // eof .form-group  
                echo '<div class="form-group">';
                echo '<label>' . esc_html__('Links color', 'wos') . '</label>';
                echo '<input class="form-control wos_colorpicker" name="login_linksColor" />';
                echo '</div>'; // eof .form-group  
                echo '<div class="form-group">';
                echo '<label>' . esc_html__('Button text color', 'wos') . '</label>';
                echo '<input class="form-control wos_colorpicker" name="login_buttonColor" />';
                echo '</div>'; // eof .form-group  
                echo '<div class="form-group">';
                echo '<label>' . esc_html__('Button background color', 'wos') . '</label>';
                echo '<input class="form-control wos_colorpicker" name="login_buttonColorBg" />';
                echo '</div>'; // eof .form-group  


                echo '</div>'; // eof .col-sm-4
            }


            echo '</div>'; // eof #wos_designSkinTab
        }

        echo '<div class="clearfix"></div>';


        echo '<p class="wos_btnsCt">'
        . ' <a href="javascript:"  data-action="wos_saveSettings" class="btn btn-primary"><span class="glyphicon glyphicon-floppy-disk"></span>' . esc_html__('Save', 'wos') . '</a>'
        . ' <a href="javascript:"  data-action="wos_resetColors" class="btn btn-warning"><span class="glyphicon glyphicon-floppy-diskglyphicon glyphicon-refresh"></span>' . esc_html__('Reset colors', 'wos') . '</a>'
        . '</p>';

        echo '</div>';
        echo '</div>';
    }

    public function view_settings_wos() {
        wp_enqueue_style('thickbox');
        wp_enqueue_script('thickbox');

        echo '<div id="wos_bootstraped" >';
        echo '<div id="wos_settings">';
        echo '<div class="col-sm-4 col-xs-6">';

        echo '<div class="form-group">';
        echo '<label>' . esc_html__('Purchase Code', 'wos') . '</label>';
        echo '<input class="form-control" name="purchaseCode"/>
             <br/>
            <span class="wos_font-12"><a href="' . $this->parent->assets_url . 'img/purchaseCode.gif" target="_blank">' . esc_html__('Where I can find my purchase code ?', 'wos') . '</a></span>';
        echo '</div>'; // eof .form-group

        echo '<div class="form-group">'
        . '<label>' . esc_html__('Keyboard shortcut to show next window', 'wos') . '</label>'
        . '<select name="key_nextWin_1"  class="form-control" >';
        echo '<option value="shift">Shift</option>';
        echo '<option value="ctrl">Control</option>';
        echo '<option value="alt">Alt</option>';
        echo '<option value="end">End</option>';
        echo '<option value="home">Home</option>';
        echo '</select> + '
        . '<select name="key_nextWin_2"  class="form-control" >';
        echo '<option value="a">a</option>';
        echo '<option value="b">b</option>';
        echo '<option value="c">c</option>';
        echo '<option value="d">d</option>';
        echo '<option value="e">e</option>';
        echo '<option value="f">f</option>';
        echo '<option value="g">g</option>';
        echo '<option value="h">h</option>';
        echo '<option value="i">i</option>';
        echo '<option value="j">j</option>';
        echo '<option value="k">k</option>';
        echo '<option value="l">l</option>';
        echo '<option value="m">m</option>';
        echo '<option value="n">n</option>';
        echo '<option value="o">o</option>';
        echo '<option value="p">p</option>';
        echo '<option value="q">q</option>';
        echo '<option value="r">r</option>';
        echo '<option value="s">s</option>';
        echo '<option value="t">t</option>';
        echo '<option value="u">u</option>';
        echo '<option value="v">v</option>';
        echo '<option value="w">w</option>';
        echo '<option value="x">x</option>';
        echo '<option value="y">y</option>';
        echo '<option value="z">z</option>';
        echo '<option value="1">1</option>';
        echo '<option value="2">2</option>';
        echo '<option value="3">3</option>';
        echo '<option value="4">4</option>';
        echo '<option value="5">5</option>';
        echo '<option value="6">6</option>';
        echo '<option value="7">7</option>';
        echo '<option value="8">8</option>';
        echo '<option value="9">9</option>';
        echo '<option value="0">0</option>';
        echo '</select>'
        . '</div>'; // eof .form-group

        echo '<div class="form-group">'
        . '<label>' . esc_html__('Keyboard shortcut to show next window', 'wos') . '</label>'
        . '<select name="key_prevWin_1"  class="form-control" >';
        echo '<option value="shift">Shift</option>';
        echo '<option value="ctrl">Control</option>';
        echo '<option value="alt">Alt</option>';
        echo '<option value="end">End</option>';
        echo '<option value="home">Home</option>';
        echo '</select> + '
        . '<select name="key_prevWin_2"  class="form-control" >';
        echo '<option value="shift">Shift</option>';
        echo '<option value="ctrl">Control</option>';
        echo '<option value="alt">Alt</option>';
        echo '<option value="end">End</option>';
        echo '<option value="home">Home</option>';
        echo '</select> + '
        . '<select name="key_prevWin_3"  class="form-control" >';
        echo '<option value="a">a</option>';
        echo '<option value="b">b</option>';
        echo '<option value="c">c</option>';
        echo '<option value="d">d</option>';
        echo '<option value="e">e</option>';
        echo '<option value="f">f</option>';
        echo '<option value="g">g</option>';
        echo '<option value="h">h</option>';
        echo '<option value="i">i</option>';
        echo '<option value="j">j</option>';
        echo '<option value="k">k</option>';
        echo '<option value="l">l</option>';
        echo '<option value="m">m</option>';
        echo '<option value="n">n</option>';
        echo '<option value="o">o</option>';
        echo '<option value="p">p</option>';
        echo '<option value="q">q</option>';
        echo '<option value="r">r</option>';
        echo '<option value="s">s</option>';
        echo '<option value="t">t</option>';
        echo '<option value="u">u</option>';
        echo '<option value="v">v</option>';
        echo '<option value="w">w</option>';
        echo '<option value="x">x</option>';
        echo '<option value="y">y</option>';
        echo '<option value="z">z</option>';
        echo '<option value="1">1</option>';
        echo '<option value="2">2</option>';
        echo '<option value="3">3</option>';
        echo '<option value="4">4</option>';
        echo '<option value="5">5</option>';
        echo '<option value="6">6</option>';
        echo '<option value="7">7</option>';
        echo '<option value="8">8</option>';
        echo '<option value="9">9</option>';
        echo '<option value="0">0</option>';
        echo '</select>'
        . '</div>'; // eof .form-group


        echo '</div>'; // eof .col-sm-4


        echo '<div class="col-sm-4 col-xs-6">';


        echo '<div class="form-group">'
        . '<label>' . esc_html__('Enable WP OS Backend ?', 'wos') . '</label>'
        . '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>" name="enableWOS"/>'
        . '</div>'; // eof .form-group


        echo '<div class="form-group">'
        . '<label>' . esc_html__('Enable admin skin', 'wos') . '</label>'
        . '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>"  name="useAdminSkin"/>'
        . '</div>'; // eof .form-group

        echo '<div class="form-group">'
        . '<label>' . esc_html__('Hide WP menu for non-admin users', 'wos') . '</label>'
        . '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>"  name="hideWPMenu"/>'
        . '</div>'; // eof .form-group
        echo '<div class="form-group">'
        . '<label>' . esc_html__('Allow non-admins to edit shortcuts', 'wos') . '</label>'
        . '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>"  name="usersCanEditShortcut"/>'
        . '</div>'; // eof .form-group   
        echo '<div class="form-group">'
        . '<label>' . esc_html__('Non-admins can edit the styles of their desktop', 'wos') . '</label>'
        . '<input type="checkbox" data-toggle="switch" data-on-text="<i class=\'fui-check\'></i>" data-off-text="<i class=\'fui-cross\'></i>"  name="usersCanChangeStyles"/>'
        . '</div>'; // eof .form-group   



        echo '</div>'; // eof .col-sm-4


        echo '<div class="col-sm-4 col-xs-6">';

        echo '<div class="form-group">'
        . '<label>' . esc_html__('Roles allowed to use OS Desktop Backend', 'wos') . '</label>'
        . '<select name="rolesAllowed"  class="form-control" multiple >';
        global $wp_roles;
        foreach ($wp_roles->roles as $key => $role) {
            echo '<option value="' . $key . '" >' . $role['name'] . '</option>';
        }
        echo '</select>'
        . '</div>'; // eof .form-group

        echo '<div class="form-group">'
        . '<label>' . esc_html__('Apply the current shortcuts to the role', 'wos') . '</label>'
        . '<select id="wos_applyshortcutsToRole"  class="form-control" >';
        global $wp_roles;
        foreach ($wp_roles->roles as $role) {
            if ($role != 'administrator') {
                echo '<option value="' . strtolower($role['name']) . '" >' . $role['name'] . '</option>';
            }
        }
        echo '</select>'
        . '<a href="javascript:" id="wos_applyShortcutsRoleBtn"  class="btn btn-default wos_fieldBtn"><span class="glyphicon glyphicon-ok"></span></a>'
        . '</div>'; // eof .form-group


        echo '</div>'; // eof .col-sm-4

        echo '<div class="clearfix"></div>';

        echo '<p class="wos_btnsCt">'
        . ' <a href="javascript:"  data-action="wos_saveSettings" class="btn btn-primary"><span class="glyphicon glyphicon-floppy-disk"></span>' . esc_html__('Save', 'wos') . '</a>'
        . '</p>';

        echo '</div>'; // eof #wos_settings
        echo '</div>'; // eof #wos_bootstraped
    }

    public function applyShortcutsRole() {
        global $wpdb;

        $role = sanitize_text_field($_POST['role']);
        $table_name = $wpdb->prefix . "wos_shortcuts";

        $usersToReset = array();
        $links = $wpdb->get_results("SELECT DISTINCT userID FROM $table_name ");
        foreach ($links as $link) {
            $user = get_userdata($link->userID);
            if (in_array($role, (array) $user->roles)) {
                $usersToReset[] = $link->userID;
            }
        }
        foreach ($usersToReset as $userToReset) {
            $wpdb->delete($table_name, array('userID' => $userToReset));
        }

        $currentUserID = get_current_user_id();
        $links = $wpdb->get_results("SELECT * FROM $table_name WHERE userID=$currentUserID");

        $allUsers = get_users(array('role' => $role));
        foreach ($allUsers as $aUser) {
            foreach ($links as $link) {
                $wpdb->insert($table_name, array('userID' => $aUser->ID, 'posX' => $link->posX, 'posY' => $link->posY, 'url' => $link->url, 'html' => $link->html));
            }
        }

        die();
    }

    public function checkURL() {
        $error = false;
        $url = sanitize_text_field($_POST['url']);
        $ch = curl_init();

        $options = array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_ENCODING => "",
            CURLOPT_AUTOREFERER => true,
            CURLOPT_CONNECTTIMEOUT => 120,
            CURLOPT_TIMEOUT => 120,
            CURLOPT_MAXREDIRS => 10,
        );
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch);
        $headers = substr($response, 0, $httpCode['header_size']);
        if (strpos($headers, 'X-Frame-Options: deny') > -1 || strpos($headers, 'X-Frame-Options: SAMEORIGIN') > -1) {
            $error = true;
        }
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        echo json_encode(array('httpcode' => $httpcode, 'error' => $error));
        die();
    }

    /**
     * update custom CSS 
     * @return void
     */
    private function generateCustomCSS() {
        //if (current_user_can('manage_options')) {
        $settings = $this->getSettings();
        $output = '';
        

        if ($settings->useAdminSkin) {

            $fontname = str_replace(' ', '+', $settings->skin_googleFont);
            $output .= '@import url(https://fonts.googleapis.com/css?family=' . $fontname . ':400,700);';

            $output .= 'body {';
            $output .= ' font-family:"' . $settings->skin_googleFont . '", sans-serif; ';
            $output .= '}';


            $output .= '#body.wos_skin #wpcontent {';
            $output .= ' background-color: ' . $settings->colorBg . ';';
            $output .= '}';
            $output .= "\n";

            $output .= 'body.wos_skin #wpadminbar{';
            $output .= ' background-color: ' . $settings->skin_topBarColorBg . ';';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.wos_skin #wpadminbar .quicklinks>ul>li>a {';
            $output .= ' background-color: ' . $settings->skin_topBarLinksColorBg . ';';
            $output .= ' color: ' . $settings->skin_topBarLinksColor . ';';
            $output .= '}';
            $output .= 'body.wos_skin #wpadminbar #adminbarsearch:before,body.wos_skin  #wpadminbar a .ab-icon:before, #wpadminbar  a .ab-item:before {';
            $output .= ' color: ' . $settings->skin_topBarLinksColor . ';';
            $output .= '}';
            $output .= 'body.wos_skin #wpadminbar .quicklinks>ul>li>a:hover,body.wos_skin #wpadminbar .quicklinks>ul>li.hover>a,body.wos_skin #wpadminbar .menupop .ab-sub-wrapper,'
                    . 'body.wos_skin #wpadminbar .quicklinks .menupop ul.ab-sub-secondary, body.wos_skin  #wpadminbar .quicklinks .menupop ul.ab-sub-secondary .ab-submenu {';
            $output .= ' background-color: ' . $settings->skin_topBarLinksColorBgHover . ' !important;';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.wos_skin #wpadminbar .quicklinks>ul>li>a:hover,body.wos_skin #wpadminbar .quicklinks>ul>li.hover>a,body.wos_skin #wpadminbar .quicklinks>ul>li.hover>a > .ab-label,body.wos_skin #wpadminbar>#wp-toolbar a:hover span.ab-label,'
                    . 'body.wos_skin  #wpadminbar  .ab-icon:hover:before,body.wos_skin  #wpadminbar li.hover >.ab-icon:before,'
                    . 'body.wos_skin  #wpadminbar  li:hover .ab-item:before,body.wos_skin  #wpadminbar  li.hover > .ab-item:before{';
            $output .= ' color: ' . $settings->skin_topBarLinksColorHover . '!important;';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.wos_skin #wpadminbar.ab-submenu .ab-item {';
            $output .= ' color: ' . $settings->skin_topBarLinksColorSubmenu . ';';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.wos_skin #wpadminbar .quicklinks>ul>li.hover>a {';
            $output .= ' color: ' . $settings->skin_topBarLinksColorSubmenu . ' !important;';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.wos_skin #wpadminbar .quicklinks .menupop ul li .ab-item:hover{';
            $output .= ' color: ' . $settings->skin_topBarLinksColorSubmenuHover . ' !important;';
            $output .= '}';
            $output .= "\n";


            $output .= 'body.wos_skin #adminmenuwrap, body.wos_skin #adminmenuback, body.wos_skin #adminmenu {';
            $output .= ' background-color: ' . $settings->skin_sideBarColorBg . ';';
            $output .= '}';

            $output .= 'body.wos_skin #adminmenu .menu-top > a, body.wos_skin #collapse-button {';
            $output .= ' background-color: ' . $settings->skin_sideBarLinksColorBg . ';';
            $output .= ' color: ' . $settings->skin_sideBarLinksColor . ';';
            $output .= ' border-top: 1px solid ' . $settings->colorBg . ';';

            $output .= '}';
            $output .= 'body.wos_skin #adminmenu .menu-top > a:hover , body.wos_skin #collapse-button:hover{';
            $output .= ' color: ' . $settings->skin_sideBarLinksColorHover . ';';
            $output .= '}';

            $output .= 'body.wos_skin .wp-responsive-open #wpadminbar #wp-admin-bar-menu-toggle .ab-icon:before {';
            $output .= ' color: ' . $settings->skin_sideBarLinksColorHover . ';';
            $output .= '}';

            $output .= 'body.wos_skin #adminmenu .wp-has-current-submenu .wp-submenu, body.wos_skin #adminmenu .current-submenu a.current{';
            $output .= ' background-color: ' . $settings->skin_sideBarLinksColorBgHover . ';';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.wos_skin #adminmenu .wp-has-current-submenu .wp-submenu a:not(.wp-has-current-submenu){';
            $output .= ' color: ' . $settings->skin_sideBarLinksColorSubmenu . ';';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.wos_skin #adminmenu .wp-has-current-submenu .wp-submenu a:not(.wp-has-current-submenu):hover{';
            $output .= ' color: ' . $settings->skin_sideBarLinksColorSubmenuHover . ';';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.wos_skin #adminmenu .wp-has-current-submenu .wp-submenu a.current,body.wos_skin #adminmenu .wp-has-current-submenu .wp-submenu a.current:hover{';
            $output .= ' color: ' . $settings->skin_sideBarLinksColorSubmenuActive . ' !important;';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.wos_skin ul#adminmenu .wp-submenu .wp-has-current-submenu ,body.wos_skin ul#adminmenu .wp-submenu .wp-has-current-submenu:hover , body.wos_skin #adminmenu li > a.current {';
            $output .= ' background-color: ' . $settings->skin_sideBarHeaderColorSubmenuActiveBg . ';';
            $output .= ' color: ' . $settings->skin_sideBarLinksColorSubmenuActive . ';';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.wos_skin #adminmenu .wp-submenu,body.wos_skin .folded #adminmenu .wp-has-current-submenu .wp-submenu,body.wos_skin .folded #adminmenu a.wp-has-current-submenu:focus+.wp-submenu{';
            $output .= ' background-color: ' . $settings->skin_sideBarLinksColorBgHover . ';';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.wos_skin #adminmenu .wp-not-current-submenu li>a,body.wos_skin  .folded #adminmenu .wp-has-current-submenu li>a {';
            $output .= ' color: ' . $settings->skin_sideBarLinksColorSubmenu . ';';
            $output .= '}';
            $output .= 'body.wos_skin #adminmenu .wp-not-current-submenu li>a:hover,body.wos_skin  .folded #adminmenu .wp-has-current-submenu li>a:hover {';
            $output .= ' color: ' . $settings->skin_sideBarLinksColorSubmenuHover . ';';
            $output .= '}';
            $output .= 'body.wos_skin ul#adminmenu a.wp-has-current-submenu:after,body.wos_skin ul#adminmenu>li.current>a:after {';
            $output .= ' border-right-color: ' . $settings->skin_sideBarLinksColorBgHover . ' !important;';
            $output .= '}';
            $output .= 'body.wos_skin ul#adminmenu .wp-has-submenu:after {';
            $output .= ' border-right-color: ' . $settings->skin_sideBarLinksColorBgHover . ' !important;';
            $output .= '}';
            $output .= 'body.wos_skin #adminmenu a:hover div.wp-menu-image:before,body.wos_skin #adminmenu a:active div.wp-menu-image:before, body.wos_skin #adminmenu .opensub a div.wp-menu-image:before,body.wos_skin #adminmenu .wp-has-submenu:hover a  div.wp-menu-image:before,'
                    . 'body.wos_skin #adminmenu li a:focus div.wp-menu-image:before,body.wos_skin  #adminmenu li.opensub div.wp-menu-image:before{';
            $output .= ' color: ' . $settings->skin_sideBarLinksColorHover . ';';
            $output .= '}';
            $output .= 'body.wos_skin #adminmenu .wp-has-current-submenu > a:not(.current) > .wp-menu-name,body.wos_skin #adminmenu .wp-has-current-submenu > a:not(.current) > .wp-menu-image:before, #adminmenu li:hover div.wp-menu-image:before {';
            $output .= ' color: ' . $settings->skin_sideBarLinksColorHover . ';';
            $output .= '}';
            $output .= 'body.wos_skin #adminmenu li a.wp-has-current-submenu .update-plugins,body.wos_skin #adminmenu li.current a .awaiting-mod,body.wos_skin #adminmenu .awaiting-mod,body.wos_skin  #adminmenu .update-plugins {';
            $output .= ' background-color: ' . $settings->skin_sideBarHeaderColorSubmenuActiveBg . ';';
            $output .= ' color: ' . $settings->skin_sideBarHeaderColorSubmenuActive . ';';
            $output .= '}';

            $output .= 'body.wos_skin {';
            $output .= ' background-color: ' . $settings->skin_pageBg . ';';
            $output .= '}';
            $output .= 'body.wos_skin .wrap .add-new-h2,body.wos_skin  .wrap .add-new-h2:active,body.wos_skin .wrap .page-title-action,body.wos_skin  .wrap .page-title-action:active, body.wos_skin .wrap .add-new-h2,body.wos_skin .wrap .wrap .page-title-action,body.wos_skin .wrap .add-new-h2:hover,body.wos_skin .wrap .wrap .page-title-action:hover, body.wos_skin a.button-primary,body.wos_skin a.button-primary:hover,body.wos_skin a.button-primary:active,body.wos_skin a.button-primary:visited,body.wos_skin a.button-primary:focus,'
                    . 'body.wos_skin.wp-core-ui .button-primary,body.wos_skin.wp-core-ui .button-primary:hover,body.wos_skin.wp-core-ui .button-primary:hover, body.wos_skin.wp-core-ui .button.button-primary.button-hero {';
            $output .= ' border-color: ' . $settings->skin_colorBtnPrimaryBg . ' !important;';
            $output .= ' background-color: ' . $settings->skin_colorBtnPrimaryBg . ' !important;';
            $output .= ' color: ' . $settings->skin_colorBtnPrimary . '!important;';
            $output .= '}';



            $output .= 'body.wos_skin #screen-meta-links .show-settings:after,body.wos_skin #post-body #visibility:before,body.wos_skin  #post-body .misc-pub-post-status:before,body.wos_skin  #post-body .misc-pub-revisions:before,body.wos_skin  .curtime #timestamp:before,body.wos_skin  span.wp-media-buttons-icon:before{';
            $output .= ' color: ' . $settings->skin_colorBtnPrimary . '!important;';
            $output .= '}';


            $output .= 'body.wos_skin a.button-secondary,body.wos_skin a.button-secondary:hover,body.wos_skin a.button-secondary:active,body.wos_skin a.button-secondary:visited,body.wos_skin a.button-secondary:focus {';
            $output .= ' border-color: ' . $settings->skin_colorBtnSecondaryBg . ' !important;';
            $output .= ' background-color: ' . $settings->skin_colorBtnSecondaryBg . ' !important;';
            $output .= ' color: ' . $settings->skin_colorBtnSecondary . ' !important;';
            $output .= '}';
            $output .= 'body.wos_skin input[type="submit"],body.wos_skin input[type="submit"]:hover,body.wos_skin input[type="submit"]:active,body.wos_skin input[type="submit"]:focus,body.wos_skin a.button,body.wos_skin a.button:hover,body.wos_skin a.button:active,body.wos_skin a.button:visited,body.wos_skin a.button:focus,'
                    . 'body.wos_skin button.button,body.wos_skin button.button:hover,body.wos_skin button.button:active,body.wos_skin button.button:visited,body.wos_skin button.button:focus    {';
            $output .= ' border-color: ' . $settings->skin_colorBtnDefaultBg . ' !important;';
            $output .= ' background-color: ' . $settings->skin_colorBtnDefaultBg . ' !important;';
            $output .= ' color: ' . $settings->skin_colorBtnDefault . ' !important;';
            $output .= '}';
            $output .= 'body.wos_skin a,body.wos_skin a:hover,body.wos_skin a:active,body.wos_skin a:visited,body.wos_skin .sorting-indicator:before {';
            $output .= ' color: ' . $settings->skin_linksColor . ';';
            $output .= '}';
            $output .= 'body.wos_skin thead,body.wos_skin thead tr th,body.wos_skin tfoot,body.wos_skin tfoot tr th,body.wos_skin th .comment-grey-bubble:before,body.wos_skin th .sorting-indicator:before   {';
            $output .= ' background-color: ' . $settings->skin_headersColorBg . ';';
            $output .= ' color: ' . $settings->skin_headersColor . ';';
            $output .= '}';
            $output .= 'body.wos_skin input[type=text]:focus,body.wos_skin  input[type=search]:focus,body.wos_skin  input[type=radio]:focus,body.wos_skin  input[type=tel]:focus,body.wos_skin  input[type=time]:focus,body.wos_skin  input[type=url]:focus,body.wos_skin  input[type=week]:focus,body.wos_skin  input[type=password]:focus,body.wos_skin  input[type=checkbox]:focus,body.wos_skin  input[type=color]:focus,body.wos_skin  input[type=date]:focus,body.wos_skin  input[type=datetime]:focus,body.wos_skin  input[type=datetime-local]:focus,body.wos_skin  input[type=email]:focus,body.wos_skin  input[type=month]:focus,body.wos_skin  input[type=number]:focus,body.wos_skin  select:focus,body.wos_skin  textarea {';
            $output .= ' border-color: ' . $settings->skin_colorBtnPrimaryBg . ';';
            $output .= '}';
            $output .= 'body.wos_skin input[type=checkbox]:checked:before {';
            $output .= ' color: ' . $settings->skin_colorBtnPrimaryBg . ';';
            $output .= '}';
        }
        
        
         if ($settings->useAdminSkin) {
            $output .= 'body.login  {';
            $output .= ' background-color: ' . $settings->login_colorBg . ';';
            $output .= '}';
            $output .= "\n";
            if ($settings->login_backgroundImage != "" && !$settings->login_useVideoBackground) {
                $output .= 'body.login {';
                $output .= ' background-image: url(' . $settings->login_backgroundImage . ');';
                $output .= '}';
                $output .= "\n";
            }
            $output .= 'body.login #loginform,body.login #login_error, body.login .message,body.login #lostpasswordform {';
            $output .= ' background-color: ' . $settings->login_panelColorBg . ';';
            $output .= ' color: ' . $settings->login_panelColor . ';';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.login label,#lostpasswordform label {';
            $output .= ' color: ' . $settings->login_panelColor . ';';
            $output .= '}';
            $output .= "\n";

            $output .= 'body.login.wp-core-ui .button-primary,.wp-core-ui .button-primary.focus, body.login.wp-core-ui .button-primary.hover, body.login.wp-core-ui .button-primary:focus, body.login.wp-core-ui .button-primary:hover {';
            $output .= ' background-color: ' . $settings->login_buttonColorBg . ';';
            $output .= ' border-color: ' . $settings->login_buttonColorBg . ';';
            $output .= ' color: ' . $settings->login_buttonColor . ';';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.login a,body.login a:hover,body.login #backtoblog a,body.login #nav a,body.login  #backtoblog a:hover,body.login  #nav a:hover{';
            $output .= ' color: ' . $settings->login_linksColor . ';';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.login  #login_error,body.login  .message {';
            $output .= ' border-left-color: ' . $settings->login_mainColor . ';';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.login  h1 a {';
            $output .= ' background-image: url(' . $settings->login_logo . ');';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.login input.input {';
            $output .= ' border-color: ' . $settings->login_panelColorBg . ';';
            $output .= ' box-shadow: 0px 0px 0px ' . $settings->login_mainColor . ';';
            $output .= '}';
            $output .= "\n";
            $output .= 'body.login input.input:focus {';
            $output .= ' border-color: ' . $settings->login_mainColor . ';';
            $output .= ' box-shadow: 0px 0px 10px ' . $settings->login_mainColor . ';';
            $output .= '}';
            $output .= "\n";

        }
        
        if ($settings->enableWOS) {
            $output .= '#wos_bootstraped.wos_backendContainer,#wos_videoBg {';
            $output .= ' background-color: ' . $settings->colorBg . ';';
            $output .= '}';
            $output .= "\n";

            $output .= '#wos_bootstraped .wos_window {';
            $output .= ' border-color: ' . $settings->colorWinHeaderBg . ';';
            $output .= ' background-color: ' . $settings->colorWinHeaderBg . ';';
            $output .= '}';
            $output .= "\n";

            $output .= '#wos_bootstraped .wos_shortcut .wos_editShortcutIcon {';
            $output .= ' background-color: ' . $settings->colorWinHeaderBg . ';';
            $output .= '}';
            $output .= "\n";

            $output .= '#wos_bootstraped .wos_window > .wos_window-header,#wos_bootstraped #wos_closedWindows-container > a {';
            $output .= ' background-color: ' . $settings->colorWinHeaderBg . ';';
            $output .= ' color: ' . $settings->colorWinHeader . ';';
            $output .= '}';
            $output .= "\n";

            $output .= '#wos_bootstraped .wos_window > .wos_window-header .wos_window-title, #wos_bootstraped .wos_window > .wos_window-header .wos_window-icon:before {';
            $output .= ' color: ' . $settings->colorWinHeader . ';';
            $output .= '}';
            $output .= "\n";


            $output .= '#wos_bootstraped .wos_window .wos_window-loader {';
            $output .= ' background-color: ' . $settings->colorWinHeaderBg . ';';
            $output .= '}';
            $output .= "\n";

            $output .= '#wos_bootstraped .wos_window .wos_window-loader .wos_spinner{';
            $output .= ' background-color: ' . $settings->colorWinHeader . ';';
            $output .= '}';
            $output .= "\n";


            $output .= '#wos_bootstraped .wos_window > .wos_window-header > .wos_window-header-icons > a.wos_window-header-icon {';
            $output .= ' background-color: ' . $settings->colorWinIconsBg . ';';
            $output .= ' color: ' . $settings->colorWinIcons . ';';
            $output .= '}';
            $output .= "\n";


            $output .= '#wos_bootstraped .wos_window > .wos_window-header > .wos_window-header-icons > a.wos_window-header-icon.wos_iconActivated,'
                    . '#wos_bootstraped .wos_window > .wos_window-header > .wos_window-header-icons > a.wos_window-header-icon:active  {';
            $output .= ' background-color: ' . $settings->colorWinIconsSelected . ';';
            $output .= ' color: ' . $settings->colorWinHeader . ';';
            $output .= '}';
            $output .= "\n";


            $output .= '#wos_bootstraped .wos_window > .wos_window-header > .wos_window-header-icons > a.wos_window-header-icon:hover {';
            $output .= ' color: ' . $settings->colorWinHeaderBg . ';';
            $output .= '}';
            $output .= "\n";


            $output .= '#wos_bootstraped #wos_rightMenu {';
            $output .= ' background-color: ' . $settings->colorContextmenuBg . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '#wos_bootstraped #wos_rightMenu ul li a {';
            $output .= ' color: ' . $settings->colorContextmenuLinks . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '#wos_bootstraped #wos_rightMenu ul li a:hover,#wos_bootstraped #wos_rightMenu ul li a:active {';
            $output .= ' color: ' . $settings->colorContextmenuLinksHover . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '#wos_bootstraped #wos_closedWindows-container{';
            $output .= ' background-color: ' . $settings->colorBottomBar . ';';
            $output .= '}';
            $output .= "\n";

            $fxGray = '0';
            $fxBlur = '0';
            $fxBrightness = '100';
            if ($settings->fxWinGray == 1) {
                $fxGray = '100';
            }
            if ($settings->fxWinBlur == 1) {
                $fxBlur = '0.7';
            }
            if ($settings->fxWinDark == 1) {
                $fxBrightness = '90%';
            }

            $defaultWinFilters = 'blur(' . $fxBlur . 'px) grayscale(' . $fxGray . '%) brightness(' . $fxBrightness . '%);';
            $defaultWinFilters = str_replace('%%', '%', $defaultWinFilters);
            $output .= '#wos_bootstraped .wos_window {';
            $output .= ' -webkit-filter: ' . $defaultWinFilters . ';';
            $output .= ' filter: ' . $defaultWinFilters . ';';
            $output .= '}';
            $output .= "\n";

            $output .= '#wos_bootstraped .wos_shortcut-title{';
            $output .= ' color: ' . $settings->colorShortcuts . ';';
            $output .= '}';
            $output .= "\n";

            $output .= '#wos_bootstraped .wos_shortcut .wp-menu-image:before{';
            $output .= ' color: ' . $settings->colorShortcuts . ';';
            $output .= '}';
            $output .= "\n";


            if ($settings->backgroundImage != "" && (!$settings->useVideoBackground || $settings->useVideoBackground == 'false')) {
                $output .= '#wos_bootstraped.wos_backendContainer {';
                $output .= ' background-image: url(' . $settings->backgroundImage . ');';
                $output .= '}';
                $output .= "\n";
            }

            if ($settings->hideWPMenu && !current_user_can('manage_options')) {
                $output .= '#adminmenumain {';
                $output .= ' display: none !important;';
                $output .= '}';
                $output .= "\n";
                $output .= '#wos_bootstraped.wos_backendContainer {';
                $output .= ' left: 0px !important;';
                $output .= '}';
                $output .= "\n";
            }
            if (!$settings->usersCanEditShortcut && !current_user_can('manage_options')) {
                $output .= '#wos_bootstraped .wos_shortcut .wos_editShortcutIcon{';
                $output .= ' display: none !important;';
                $output .= '}';
                $output .= "\n";
                $output .= '#wos_bootstraped #wos_shortcut-trash{';
                $output .= ' display: none !important;';
                $output .= '}';
                $output .= "\n";
            }
        }


        if (file_exists($this->parent->assets_dir . '/css/wos_customCss.css')) {
            chmod($this->parent->assets_dir . '/css/wos_customCss.css', $this->parent->chmodWrite);
        }
        $cssFile = fopen($this->parent->assets_dir . '/css/wos_customCss.css', "w+") or die("Can't open custom css file");
        fwrite($cssFile, $output);

        $users = get_users(array('fields' => array('ID')));
        foreach ($users as $user) {
            $this->generateCustomCSSForUser($user->ID);
        }
    }

    /**
     * update custom CSS for a specific user
     * @return void
     */
    private function generateCustomCSSForUser($userID) {

        global $wpdb;
        $settings = $this->getSettings();
        $output = '';
        $userMeta = get_user_meta($userID);
        if ($settings->usersCanChangeStyles && array_key_exists($wpdb->prefix . 'wos_colorWinHeaderBg', $userMeta) && $userMeta[$wpdb->prefix . 'wos_colorWinHeaderBg'] != false) {
            if ($userMeta[$wpdb->prefix . 'wos_colorWinHeader'] != false) {
                $settings->colorWinHeader = $userMeta[$wpdb->prefix . 'wos_colorWinHeader'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_colorWinHeaderBg'] != false) {
                $settings->colorWinHeaderBg = $userMeta[$wpdb->prefix . 'wos_colorWinHeaderBg'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_colorWinIconsBg'] != false) {
                $settings->colorWinIconsBg = $userMeta[$wpdb->prefix . 'wos_colorWinIconsBg'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_colorWinIcons'] != false) {
                $settings->colorWinIcons = $userMeta[$wpdb->prefix . 'wos_colorWinIcons'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_colorWinIconsSelected'] != false) {
                $settings->colorWinIconsSelected = $userMeta[$wpdb->prefix . 'wos_colorWinIconsSelected'][0];
            }
            if (array_key_exists($wpdb->prefix . 'wos_colorWPMenuLinks', $userMeta)) {

                if ($userMeta[$wpdb->prefix . 'wos_colorWPMenuLinks'] != false) {
                    $settings->colorWPMenuLinks = $userMeta[$wpdb->prefix . 'wos_colorWPMenuLinks'][0];
                }
            }

            if (array_key_exists($wpdb->prefix . 'wos_colorWPMenuBadges', $userMeta)) {
                if ($userMeta[$wpdb->prefix . 'wos_colorWPMenuBadges'] != false) {
                    $settings->colorWPMenuBadges = $userMeta[$wpdb->prefix . 'wos_colorWPMenuBadges'][0];
                }
            }
            if ($userMeta[$wpdb->prefix . 'wos_colorShortcuts'] != false) {
                $settings->colorShortcuts = $userMeta[$wpdb->prefix . 'wos_colorShortcuts'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_colorContextmenuBg'] != false) {
                $settings->colorContextmenuBg = $userMeta[$wpdb->prefix . 'wos_colorContextmenuBg'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_colorContextmenuLinks'] != false) {
                $settings->colorContextmenuLinks = $userMeta[$wpdb->prefix . 'wos_colorContextmenuLinks'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_colorContextmenuLinksHover'] != false) {
                $settings->colorContextmenuLinksHover = $userMeta[$wpdb->prefix . 'wos_colorContextmenuLinksHover'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_fxWinGray'] != false) {
                $settings->fxWinGray = $userMeta[$wpdb->prefix . 'wos_fxWinGray'][0];
                if ($userMeta[$wpdb->prefix . 'wos_fxWinGray'] == false) {
                    $settings->fxWinGray = 0;
                }
            }
            if ($userMeta[$wpdb->prefix . 'wos_fxWinBlur'] != false) {
                $settings->fxWinBlur = $userMeta[$wpdb->prefix . 'wos_fxWinBlur'][0];
                if ($userMeta[$wpdb->prefix . 'wos_fxWinBlur'] == false) {
                    $settings->fxWinBlur = 0;
                }
            }
            if ($userMeta[$wpdb->prefix . 'wos_fxWinDark'] != false) {
                $settings->fxWinDark = $userMeta[$wpdb->prefix . 'wos_fxWinDark'][0];
                if ($userMeta[$wpdb->prefix . 'wos_fxWinDark'] == false) {
                    $settings->fxWinDark = 0;
                }
            }
            if ($userMeta[$wpdb->prefix . 'wos_useVideoBackground'] != false) {
                $settings->useVideoBackground = $userMeta[$wpdb->prefix . 'wos_useVideoBackground'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_backgroundImage'] != false) {
                $settings->backgroundImage = $userMeta[$wpdb->prefix . 'wos_backgroundImage'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_backgroundVideo'] != false) {
                $settings->backgroundVideo = $userMeta[$wpdb->prefix . 'wos_backgroundVideo'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_colorBottomBar'] != false) {
                $settings->colorBottomBar = $userMeta[$wpdb->prefix . 'wos_colorBottomBar'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_colorBottomAlpha'] != false) {
                $settings->colorBottomAlpha = $userMeta[$wpdb->prefix . 'wos_colorBottomAlpha'][0];
                if ($userMeta[$wpdb->prefix . 'wos_colorBottomAlpha'] == false) {
                    $settings->colorBottomAlpha = 0;
                }
            }
            if ($userMeta[$wpdb->prefix . 'wos_colorBg'] != false) {
                $settings->colorBg = $userMeta[$wpdb->prefix . 'wos_colorBg'][0];
            }

            if ($userMeta[$wpdb->prefix . 'wos_skin_topBarColorBg'] != false) {
                $settings->skin_topBarColorBg = $userMeta[$wpdb->prefix . 'wos_skin_topBarColorBg'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_topBarLinksColorBg'] != false) {
                $settings->skin_topBarLinksColorBg = $userMeta[$wpdb->prefix . 'wos_skin_topBarLinksColorBg'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_topBarLinksColorBgHover'] != false) {
                $settings->skin_topBarLinksColorBgHover = $userMeta[$wpdb->prefix . 'wos_skin_topBarLinksColorBgHover'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_topBarLinksColor'] != false) {
                $settings->skin_topBarLinksColor = $userMeta[$wpdb->prefix . 'wos_skin_topBarLinksColor'][0];
            }
            if (array_key_exists($wpdb->prefix . 'wos_skin_topBarLinksColorSubmenu', $userMeta)) {
                if ($userMeta[$wpdb->prefix . 'wos_skin_topBarLinksColorSubmenu'] != false) {
                    $settings->skin_topBarLinksColorSubmenu = $userMeta[$wpdb->prefix . 'wos_skin_topBarLinksColorSubmenu'][0];
                }
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_topBarLinksColorSubmenuHover'] != false) {
                $settings->skin_topBarLinksColorSubmenuHover = $userMeta[$wpdb->prefix . 'wos_skin_topBarLinksColorSubmenuHover'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_sideBarColorBg'] != false) {
                $settings->skin_sideBarColorBg = $userMeta[$wpdb->prefix . 'wos_skin_sideBarColorBg'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColorBg'] != false) {
                $settings->skin_sideBarLinksColorBg = $userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColorBg'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColorBgHover'] != false) {
                $settings->skin_sideBarLinksColorBgHover = $userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColorBgHover'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColorSubmenu'] != false) {
                $settings->skin_sideBarLinksColorSubmenu = $userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColorSubmenu'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColorSubmenuActive'] != false) {
                $settings->skin_sideBarLinksColorSubmenuActive = $userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColorSubmenuActive'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_sideBarHeaderColorSubmenuActiveBg'] != false) {
                $settings->skin_sideBarHeaderColorSubmenuActiveBg = $userMeta[$wpdb->prefix . 'wos_skin_sideBarHeaderColorSubmenuActiveBg'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_sideBarHeaderColorSubmenuActive'] != false) {
                $settings->skin_sideBarHeaderColorSubmenuActive = $userMeta[$wpdb->prefix . 'wos_skin_sideBarHeaderColorSubmenuActive'][0];
            }


            if ($userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColorSubmenuHover'] != false) {
                $settings->skin_sideBarLinksColorSubmenuHover = $userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColorSubmenuHover'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColor'] != false) {
                $settings->skin_sideBarLinksColor = $userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColor'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColorHover'] != false) {
                $settings->skin_sideBarLinksColorHover = $userMeta[$wpdb->prefix . 'wos_skin_sideBarLinksColorHover'][0];
            }


            if ($userMeta[$wpdb->prefix . 'wos_skin_googleFont'] != false) {
                $settings->skin_googleFont = $userMeta[$wpdb->prefix . 'wos_skin_googleFont'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_colorBtnPrimary'] != false) {
                $settings->skin_colorBtnPrimary = $userMeta[$wpdb->prefix . 'wos_skin_colorBtnPrimary'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_colorBtnPrimaryBg'] != false) {
                $settings->skin_colorBtnPrimaryBg = $userMeta[$wpdb->prefix . 'wos_skin_colorBtnPrimaryBg'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_colorBtnSecondary'] != false) {
                $settings->skin_colorBtnSecondary = $userMeta[$wpdb->prefix . 'wos_skin_colorBtnSecondary'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_colorBtnSecondaryBg'] != false) {
                $settings->skin_colorBtnSecondaryBg = $userMeta[$wpdb->prefix . 'wos_skin_colorBtnSecondaryBg'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_colorBtnDefault'] != false) {
                $settings->skin_colorBtnDefault = $userMeta[$wpdb->prefix . 'wos_skin_colorBtnDefault'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_colorBtnDefaultBg'] != false) {
                $settings->skin_colorBtnDefaultBg = $userMeta[$wpdb->prefix . 'wos_skin_colorBtnDefaultBg'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_pageBg'] != false) {
                $settings->skin_pageBg = $userMeta[$wpdb->prefix . 'wos_skin_pageBg'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_linksColor'] != false) {
                $settings->skin_linksColor = $userMeta[$wpdb->prefix . 'wos_skin_linksColor'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_headersColor'] != false) {
                $settings->skin_headersColor = $userMeta[$wpdb->prefix . 'wos_skin_headersColor'][0];
            }
            if ($userMeta[$wpdb->prefix . 'wos_skin_headersColorBg'] != false) {
                $settings->skin_headersColorBg = $userMeta[$wpdb->prefix . 'wos_skin_headersColorBg'][0];
            }

            $output = '';

            if ($settings->enableWOS) {
                $output .= '#wos_bootstraped.wos_backendContainer,#wos_videoBg {';
                $output .= ' background-color: ' . $settings->colorBg . ';';
                $output .= '}';
                $output .= "\n";

                $output .= '#wos_bootstraped .wos_window {';
                $output .= ' border-color: ' . $settings->colorWinHeaderBg . ';';
                $output .= ' background-color: ' . $settings->colorWinHeaderBg . ';';
                $output .= '}';
                $output .= "\n";

                $output .= '#wos_bootstraped .wos_shortcut .wos_editShortcutIcon {';
                $output .= ' background-color: ' . $settings->colorWinHeaderBg . ';';
                $output .= '}';
                $output .= "\n";

                $output .= '#wos_bootstraped .wos_window > .wos_window-header,#wos_bootstraped #wos_closedWindows-container > a {';
                $output .= ' background-color: ' . $settings->colorWinHeaderBg . ';';
                $output .= ' color: ' . $settings->colorWinHeader . ';';
                $output .= '}';
                $output .= "\n";

                $output .= '#wos_bootstraped .wos_window > .wos_window-header .wos_window-title, #wos_bootstraped .wos_window > .wos_window-header .wos_window-icon:before {';
                $output .= ' color: ' . $settings->colorWinHeader . ';';
                $output .= '}';
                $output .= "\n";


                $output .= '#wos_bootstraped .wos_window .wos_window-loader {';
                $output .= ' background-color: ' . $settings->colorWinHeaderBg . ';';
                $output .= '}';
                $output .= "\n";

                $output .= '#wos_bootstraped .wos_window .wos_window-loader .wos_spinner{';
                $output .= ' background-color: ' . $settings->colorWinHeader . ';';
                $output .= '}';
                $output .= "\n";


                $output .= '#wos_bootstraped .wos_window > .wos_window-header > .wos_window-header-icons > a.wos_window-header-icon {';
                $output .= ' background-color: ' . $settings->colorWinIconsBg . ';';
                $output .= ' color: ' . $settings->colorWinIcons . ';';
                $output .= '}';
                $output .= "\n";


                $output .= '#wos_bootstraped .wos_window > .wos_window-header > .wos_window-header-icons > a.wos_window-header-icon.wos_iconActivated,'
                        . '#wos_bootstraped .wos_window > .wos_window-header > .wos_window-header-icons > a.wos_window-header-icon:active  {';
                $output .= ' background-color: ' . $settings->colorWinIconsSelected . ';';
                $output .= ' color: ' . $settings->colorWinHeader . ';';
                $output .= '}';
                $output .= "\n";


                $output .= '#wos_bootstraped .wos_window > .wos_window-header > .wos_window-header-icons > a.wos_window-header-icon:hover {';
                $output .= ' color: ' . $settings->colorWinHeaderBg . ';';
                $output .= '}';
                $output .= "\n";


                $output .= '#wos_bootstraped #wos_rightMenu {';
                $output .= ' background-color: ' . $settings->colorContextmenuBg . ';';
                $output .= '}';
                $output .= "\n";
                $output .= '#wos_bootstraped #wos_rightMenu ul li a {';
                $output .= ' color: ' . $settings->colorContextmenuLinks . ';';
                $output .= '}';
                $output .= "\n";
                $output .= '#wos_bootstraped #wos_rightMenu ul li a:hover,#wos_bootstraped #wos_rightMenu ul li a:active {';
                $output .= ' color: ' . $settings->colorContextmenuLinksHover . ';';
                $output .= '}';
                $output .= "\n";
                $output .= '#wos_bootstraped #wos_closedWindows-container{';
                $output .= ' background-color: ' . $settings->colorBottomBar . ';';
                $output .= '}';
                $output .= "\n";

                $fxGray = '0';
                $fxBlur = '0';
                $fxBrightness = '100';
                if ($settings->fxWinGray == 1) {
                    $fxGray = '100';
                }
                if ($settings->fxWinBlur == 1) {
                    $fxBlur = '0.7';
                }
                if ($settings->fxWinDark == 1) {
                    $fxBrightness = '90%';
                }

                $defaultWinFilters = 'blur(' . $fxBlur . 'px) grayscale(' . $fxGray . '%) brightness(' . $fxBrightness . '%);';
                $defaultWinFilters = str_replace('%%', '%', $defaultWinFilters);
                $output .= '#wos_bootstraped .wos_window {';
                $output .= ' -webkit-filter: ' . $defaultWinFilters . ';';
                $output .= ' filter: ' . $defaultWinFilters . ';';
                $output .= '}';
                $output .= "\n";

                $output .= '#wos_bootstraped .wos_shortcut-title{';
                $output .= ' color: ' . $settings->colorShortcuts . ';';
                $output .= '}';
                $output .= "\n";

                $output .= '#wos_bootstraped .wos_shortcut .wp-menu-image:before{';
                $output .= ' color: ' . $settings->colorShortcuts . ';';
                $output .= '}';
                $output .= "\n";


                if ($settings->backgroundImage != "" && (!$settings->useVideoBackground || $settings->useVideoBackground == 'false')) {
                    $output .= '#wos_bootstraped.wos_backendContainer {';
                    $output .= ' background-image: url(' . $settings->backgroundImage . ');';
                    $output .= '}';
                    $output .= "\n";
                }

                if ($settings->hideWPMenu && !current_user_can('manage_options')) {
                    $output .= '#adminmenumain {';
                    $output .= ' display: none !important;';
                    $output .= '}';
                    $output .= "\n";
                    $output .= '#wos_bootstraped.wos_backendContainer {';
                    $output .= ' left: 0px !important;';
                    $output .= '}';
                    $output .= "\n";
                }
                if (!$settings->usersCanEditShortcut && !current_user_can('manage_options')) {
                    $output .= '#wos_bootstraped .wos_shortcut .wos_editShortcutIcon{';
                    $output .= ' display: none !important;';
                    $output .= '}';
                    $output .= "\n";
                    $output .= '#wos_bootstraped #wos_shortcut-trash{';
                    $output .= ' display: none !important;';
                    $output .= '}';
                    $output .= "\n";
                }
            }

            if ($settings->useAdminSkin) {

                $fontname = str_replace(' ', '+', $settings->skin_googleFont);
                $output .= '@import url(https://fonts.googleapis.com/css?family=' . $fontname . ':400,700);';

                $output .= 'body {';
                $output .= ' font-family:"' . $settings->skin_googleFont . '", sans-serif; ';
                $output .= '}';


                $output .= '#body.wos_skin #wpcontent {';
                $output .= ' background-color: ' . $settings->colorBg . ';';
                $output .= '}';
                $output .= "\n";

                $output .= 'body.wos_skin #wpadminbar{';
                $output .= ' background-color: ' . $settings->skin_topBarColorBg . ';';
                $output .= '}';
                $output .= "\n";
                $output .= 'body.wos_skin #wpadminbar .quicklinks>ul>li>a {';
                $output .= ' background-color: ' . $settings->skin_topBarLinksColorBg . ';';
                $output .= ' color: ' . $settings->skin_topBarLinksColor . ';';
                $output .= '}';
                $output .= 'body.wos_skin #wpadminbar #adminbarsearch:before,body.wos_skin  #wpadminbar a .ab-icon:before, #wpadminbar  a .ab-item:before {';
                $output .= ' color: ' . $settings->skin_topBarLinksColor . ';';
                $output .= '}';
                $output .= 'body.wos_skin #wpadminbar .quicklinks>ul>li>a:hover,body.wos_skin #wpadminbar .quicklinks>ul>li.hover>a,body.wos_skin #wpadminbar .menupop .ab-sub-wrapper,'
                        . 'body.wos_skin #wpadminbar .quicklinks .menupop ul.ab-sub-secondary, body.wos_skin  #wpadminbar .quicklinks .menupop ul.ab-sub-secondary .ab-submenu {';
                $output .= ' background-color: ' . $settings->skin_topBarLinksColorBgHover . ' !important;';
                $output .= '}';
                $output .= "\n";
                $output .= 'body.wos_skin #wpadminbar .quicklinks>ul>li>a:hover,body.wos_skin #wpadminbar .quicklinks>ul>li.hover>a,body.wos_skin #wpadminbar .quicklinks>ul>li.hover>a > .ab-label,body.wos_skin #wpadminbar>#wp-toolbar a:hover span.ab-label,'
                        . 'body.wos_skin  #wpadminbar  .ab-icon:hover:before,body.wos_skin  #wpadminbar li.hover >.ab-icon:before,'
                        . 'body.wos_skin  #wpadminbar  li:hover .ab-item:before,body.wos_skin  #wpadminbar  li.hover > .ab-item:before{';
                $output .= ' color: ' . $settings->skin_topBarLinksColorHover . '!important;';
                $output .= '}';
                $output .= "\n";
                $output .= 'body.wos_skin #wpadminbar.ab-submenu .ab-item {';
                $output .= ' color: ' . $settings->skin_topBarLinksColorSubmenu . ';';
                $output .= '}';
                $output .= "\n";
                $output .= 'body.wos_skin #wpadminbar .quicklinks>ul>li.hover>a {';
                $output .= ' color: ' . $settings->skin_topBarLinksColorSubmenu . ' !important;';
                $output .= '}';
                $output .= "\n";
                $output .= 'body.wos_skin #wpadminbar .quicklinks .menupop ul li .ab-item:hover{';
                $output .= ' color: ' . $settings->skin_topBarLinksColorSubmenuHover . ' !important;';
                $output .= '}';
                $output .= "\n";


                $output .= 'body.wos_skin #adminmenuwrap, body.wos_skin #adminmenuback, body.wos_skin #adminmenu {';
                $output .= ' background-color: ' . $settings->skin_sideBarColorBg . ';';
                $output .= '}';

                $output .= 'body.wos_skin #adminmenu .menu-top > a, body.wos_skin #collapse-button {';
                $output .= ' background-color: ' . $settings->skin_sideBarLinksColorBg . ';';
                $output .= ' color: ' . $settings->skin_sideBarLinksColor . ';';
                $output .= ' border-top: 1px solid ' . $settings->colorBg . ';';

                $output .= '}';
                $output .= 'body.wos_skin #adminmenu .menu-top > a:hover , body.wos_skin #collapse-button:hover{';
                $output .= ' color: ' . $settings->skin_sideBarLinksColorHover . ';';
                $output .= '}';

                $output .= 'body.wos_skin .wp-responsive-open #wpadminbar #wp-admin-bar-menu-toggle .ab-icon:before {';
                $output .= ' color: ' . $settings->skin_sideBarLinksColorHover . ';';
                $output .= '}';

                $output .= 'body.wos_skin #adminmenu .wp-has-current-submenu .wp-submenu, body.wos_skin #adminmenu .current-submenu a.current{';
                $output .= ' background-color: ' . $settings->skin_sideBarLinksColorBgHover . ';';
                $output .= '}';
                $output .= "\n";
                $output .= 'body.wos_skin #adminmenu .wp-has-current-submenu .wp-submenu a:not(.wp-has-current-submenu){';
                $output .= ' color: ' . $settings->skin_sideBarLinksColorSubmenu . ';';
                $output .= '}';
                $output .= "\n";
                $output .= 'body.wos_skin #adminmenu .wp-has-current-submenu .wp-submenu a:not(.wp-has-current-submenu):hover{';
                $output .= ' color: ' . $settings->skin_sideBarLinksColorSubmenuHover . ';';
                $output .= '}';
                $output .= "\n";
                $output .= 'body.wos_skin #adminmenu .wp-has-current-submenu .wp-submenu a.current,body.wos_skin #adminmenu .wp-has-current-submenu .wp-submenu a.current:hover{';
                $output .= ' color: ' . $settings->skin_sideBarLinksColorSubmenuActive . ' !important;';
                $output .= '}';
                $output .= "\n";
                $output .= 'body.wos_skin ul#adminmenu .wp-submenu .wp-has-current-submenu ,body.wos_skin ul#adminmenu .wp-submenu .wp-has-current-submenu:hover , body.wos_skin #adminmenu li > a.current {';
                $output .= ' background-color: ' . $settings->skin_sideBarHeaderColorSubmenuActiveBg . ';';
                $output .= ' color: ' . $settings->skin_sideBarLinksColorSubmenuActive . ';';
                $output .= '}';
                $output .= "\n";
                $output .= 'body.wos_skin #adminmenu .wp-submenu,body.wos_skin .folded #adminmenu .wp-has-current-submenu .wp-submenu,body.wos_skin .folded #adminmenu a.wp-has-current-submenu:focus+.wp-submenu{';
                $output .= ' background-color: ' . $settings->skin_sideBarLinksColorBgHover . ';';
                $output .= '}';
                $output .= "\n";
                $output .= 'body.wos_skin #adminmenu .wp-not-current-submenu li>a,body.wos_skin  .folded #adminmenu .wp-has-current-submenu li>a {';
                $output .= ' color: ' . $settings->skin_sideBarLinksColorSubmenu . ';';
                $output .= '}';
                $output .= 'body.wos_skin #adminmenu .wp-not-current-submenu li>a:hover,body.wos_skin  .folded #adminmenu .wp-has-current-submenu li>a:hover {';
                $output .= ' color: ' . $settings->skin_sideBarLinksColorSubmenuHover . ';';
                $output .= '}';
                $output .= 'body.wos_skin ul#adminmenu a.wp-has-current-submenu:after,body.wos_skin ul#adminmenu>li.current>a:after {';
                $output .= ' border-right-color: ' . $settings->skin_sideBarLinksColorBgHover . ' !important;';
                $output .= '}';
                $output .= 'body.wos_skin ul#adminmenu .wp-has-submenu:after {';
                $output .= ' border-right-color: ' . $settings->skin_sideBarLinksColorBgHover . ' !important;';
                $output .= '}';
                $output .= 'body.wos_skin #adminmenu a:hover div.wp-menu-image:before,body.wos_skin #adminmenu a:active div.wp-menu-image:before, body.wos_skin #adminmenu .opensub a div.wp-menu-image:before,body.wos_skin #adminmenu .wp-has-submenu:hover a  div.wp-menu-image:before,'
                        . 'body.wos_skin #adminmenu li a:focus div.wp-menu-image:before,body.wos_skin  #adminmenu li.opensub div.wp-menu-image:before{';
                $output .= ' color: ' . $settings->skin_sideBarLinksColorHover . ';';
                $output .= '}';
                $output .= 'body.wos_skin #adminmenu .wp-has-current-submenu > a:not(.current) > .wp-menu-name,body.wos_skin #adminmenu .wp-has-current-submenu > a:not(.current) > .wp-menu-image:before, #adminmenu li:hover div.wp-menu-image:before {';
                $output .= ' color: ' . $settings->skin_sideBarLinksColorHover . ';';
                $output .= '}';
                $output .= 'body.wos_skin #adminmenu li a.wp-has-current-submenu .update-plugins,body.wos_skin #adminmenu li.current a .awaiting-mod,body.wos_skin #adminmenu .awaiting-mod,body.wos_skin  #adminmenu .update-plugins {';
                $output .= ' background-color: ' . $settings->skin_sideBarHeaderColorSubmenuActiveBg . ';';
                $output .= ' color: ' . $settings->skin_sideBarHeaderColorSubmenuActive . ';';
                $output .= '}';

                $output .= 'body.wos_skin {';
                $output .= ' background-color: ' . $settings->skin_pageBg . ';';
                $output .= '}';
                $output .= 'body.wos_skin .wrap .add-new-h2,body.wos_skin  .wrap .add-new-h2:active,body.wos_skin .wrap .page-title-action,body.wos_skin  .wrap .page-title-action:active, body.wos_skin .wrap .add-new-h2,body.wos_skin .wrap .wrap .page-title-action,body.wos_skin .wrap .add-new-h2:hover,body.wos_skin .wrap .wrap .page-title-action:hover, body.wos_skin a.button-primary,body.wos_skin a.button-primary:hover,body.wos_skin a.button-primary:active,body.wos_skin a.button-primary:visited,body.wos_skin a.button-primary:focus,'
                        . 'body.wos_skin.wp-core-ui .button-primary,body.wos_skin.wp-core-ui .button-primary:hover,body.wos_skin.wp-core-ui .button-primary:hover, body.wos_skin.wp-core-ui .button.button-primary.button-hero {';
                $output .= ' border-color: ' . $settings->skin_colorBtnPrimaryBg . ' !important;';
                $output .= ' background-color: ' . $settings->skin_colorBtnPrimaryBg . ' !important;';
                $output .= ' color: ' . $settings->skin_colorBtnPrimary . '!important;';
                $output .= '}';



                $output .= 'body.wos_skin #screen-meta-links .show-settings:after,body.wos_skin #post-body #visibility:before,body.wos_skin  #post-body .misc-pub-post-status:before,body.wos_skin  #post-body .misc-pub-revisions:before,body.wos_skin  .curtime #timestamp:before,body.wos_skin  span.wp-media-buttons-icon:before{';
                $output .= ' color: ' . $settings->skin_colorBtnPrimary . '!important;';
                $output .= '}';


                $output .= 'body.wos_skin a.button-secondary,body.wos_skin a.button-secondary:hover,body.wos_skin a.button-secondary:active,body.wos_skin a.button-secondary:visited,body.wos_skin a.button-secondary:focus {';
                $output .= ' border-color: ' . $settings->skin_colorBtnSecondaryBg . ' !important;';
                $output .= ' background-color: ' . $settings->skin_colorBtnSecondaryBg . ' !important;';
                $output .= ' color: ' . $settings->skin_colorBtnSecondary . ' !important;';
                $output .= '}';
                $output .= 'body.wos_skin input[type="submit"],body.wos_skin input[type="submit"]:hover,body.wos_skin input[type="submit"]:active,body.wos_skin input[type="submit"]:focus,body.wos_skin a.button,body.wos_skin a.button:hover,body.wos_skin a.button:active,body.wos_skin a.button:visited,body.wos_skin a.button:focus,'
                        . 'body.wos_skin button.button,body.wos_skin button.button:hover,body.wos_skin button.button:active,body.wos_skin button.button:visited,body.wos_skin button.button:focus    {';
                $output .= ' border-color: ' . $settings->skin_colorBtnDefaultBg . ' !important;';
                $output .= ' background-color: ' . $settings->skin_colorBtnDefaultBg . ' !important;';
                $output .= ' color: ' . $settings->skin_colorBtnDefault . ' !important;';
                $output .= '}';
                $output .= 'body.wos_skin a,body.wos_skin a:hover,body.wos_skin a:active,body.wos_skin a:visited,body.wos_skin .sorting-indicator:before {';
                $output .= ' color: ' . $settings->skin_linksColor . ';';
                $output .= '}';
                $output .= 'body.wos_skin thead,body.wos_skin thead tr th,body.wos_skin tfoot,body.wos_skin tfoot tr th,body.wos_skin th .comment-grey-bubble:before,body.wos_skin th .sorting-indicator:before   {';
                $output .= ' background-color: ' . $settings->skin_headersColorBg . ';';
                $output .= ' color: ' . $settings->skin_headersColor . ';';
                $output .= '}';
                $output .= 'body.wos_skin input[type=text]:focus,body.wos_skin  input[type=search]:focus,body.wos_skin  input[type=radio]:focus,body.wos_skin  input[type=tel]:focus,body.wos_skin  input[type=time]:focus,body.wos_skin  input[type=url]:focus,body.wos_skin  input[type=week]:focus,body.wos_skin  input[type=password]:focus,body.wos_skin  input[type=checkbox]:focus,body.wos_skin  input[type=color]:focus,body.wos_skin  input[type=date]:focus,body.wos_skin  input[type=datetime]:focus,body.wos_skin  input[type=datetime-local]:focus,body.wos_skin  input[type=email]:focus,body.wos_skin  input[type=month]:focus,body.wos_skin  input[type=number]:focus,body.wos_skin  select:focus,body.wos_skin  textarea {';
                $output .= ' border-color: ' . $settings->skin_colorBtnPrimaryBg . ';';
                $output .= '}';
                $output .= 'body.wos_skin input[type=checkbox]:checked:before {';
                $output .= ' color: ' . $settings->skin_colorBtnPrimaryBg . ';';
                $output .= '}';
            }

            if (file_exists($this->parent->assets_dir . '/css/wos_customCss_' . $userID . '.css')) {
                chmod($this->parent->assets_dir . '/css/wos_customCss_' . $userID . '.css', $this->parent->chmodWrite);
            }
            $cssFile = fopen($this->parent->assets_dir . '/css/wos_customCss_' . $userID . '.css', "w+") or die("Can't open custom css file");
            fwrite($cssFile, $output);
        }
    }

    /**
     * Main Instance
     *
     *
     * @since 1.0.0
     * @static
     * @return Main instance
     */
    public static function instance($parent) {
        if (is_null(self::$_instance)) {
            self::$_instance = new self($parent);
        }
        return self::$_instance;
    }

    // End instance()

    /**
     * Cloning is forbidden.
     *
     * @since 1.0.0
     */
    public function __clone() {
        _doing_it_wrong(__FUNCTION__, '', $this->parent->_version);
    }

// End __clone()

    /**
     * Unserializing instances of this class is forbidden.
     *
     * @since 1.0.0
     */
    public function __wakeup() {
        _doing_it_wrong(__FUNCTION__, '', $this->parent->_version);
    }

// End __wakeup()
}
